/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/groovy/findUsages/PropertyMethodReferenceSearchExecutor;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "intellij.groovy.psi"})
public final class PropertyMethodReferenceSearchExecutor
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        String propertyName;
        String string;
        PsiMethod method = queryParameters.getMethod();
        if (GdkMethodUtil.isCategoryMethod(method, null, null, PsiSubstitutor.EMPTY)) {
            GrGdkMethod cat;
            GrGdkMethod grGdkMethod = cat = GrGdkMethodImpl.createGdkMethod(method, false, null);
            if (grGdkMethod == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
            }
            string = GroovyPropertyUtils.getPropertyName(grGdkMethod);
        } else {
            string = propertyName = GroovyPropertyUtils.getPropertyName(method);
        }
        if (propertyName == null) {
            return;
        }
        SearchScope onlyGroovyFiles = GroovyScopeUtil.restrictScopeToGroovyFiles(queryParameters.getEffectiveSearchScope(), GroovyScopeUtil.getEffectiveScope(method));
        queryParameters.getOptimizer().searchWord(propertyName, onlyGroovyFiles, (short)1, true, (PsiElement)method);
        if (!GroovyPropertyUtils.isPropertyName(propertyName)) {
            SearchRequestCollector searchRequestCollector = queryParameters.getOptimizer();
            String string2 = StringUtil.decapitalize((String)propertyName);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            searchRequestCollector.searchWord(string2, onlyGroovyFiles, (short)1, true, (PsiElement)method);
        }
    }

    public PropertyMethodReferenceSearchExecutor() {
        super(true);
    }
}

