/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.editorActions.StringLiteralCopyPasteProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.StringKind;
import org.jetbrains.plugins.groovy.lang.psi.util.StringUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;

public class GroovyLiteralCopyPasteProcessor
extends StringLiteralCopyPasteProcessor {
    @Nullable
    protected TextRange getEscapedRange(@NotNull PsiElement token) {
        ASTNode node = token.getNode();
        if (node == null) {
            return null;
        }
        IElementType tokenType = node.getElementType();
        if (GroovyTokenSets.STRING_LITERALS.contains(tokenType)) {
            String text = token.getText();
            if (text == null) {
                return null;
            }
            return GroovyStringLiteralManipulator.getLiteralRange(text).shiftRight(node.getStartOffset());
        }
        if (tokenType == GroovyElementTypes.SLASHY_CONTENT || tokenType == GroovyElementTypes.DOLLAR_SLASHY_CONTENT) {
            return token.getTextRange();
        }
        return null;
    }

    @Nullable
    protected String unescape(String s, PsiElement token) {
        StringKind stringKind = GroovyLiteralCopyPasteProcessor.getStringKindByToken(token);
        return stringKind == null ? null : stringKind.unescape(s);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        StringKind stringKind = GroovyLiteralCopyPasteProcessor.findStringKind(file, selectionStart, selectionEnd);
        if (stringKind == null) {
            return text;
        }
        if (rawText != null && GroovyLiteralCopyPasteProcessor.canPasteRaw(text, rawText.rawText, stringKind)) {
            return rawText.rawText;
        }
        StringBuilder buffer = new StringBuilder(text.length());
        String breaker = stringKind.getLineBreaker();
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            buffer.append(GroovyLiteralCopyPasteProcessor.escape(stringKind, line));
            if (i != lines.length - 1) {
                buffer.append(breaker);
                continue;
            }
            if (!text.endsWith("\n")) continue;
            buffer.append(stringKind.escape("\n"));
        }
        return buffer.toString();
    }

    private static boolean canPasteRaw(String text, String rawText, StringKind kind) {
        if (!text.equals(kind.unescape(rawText))) {
            return false;
        }
        if (kind == StringKind.SINGLE_QUOTED) {
            return StringUtilKt.isValidSingleQuotedStringContent(rawText);
        }
        if (kind == StringKind.DOUBLE_QUOTED) {
            return StringUtilKt.isValidDoubleQuotedStringContent(rawText);
        }
        return true;
    }

    @NotNull
    private static String escape(@NotNull StringKind kind, @NotNull String s) {
        if (s.isEmpty()) {
            return s;
        }
        if (kind != StringKind.DOUBLE_QUOTED && kind != StringKind.TRIPLE_DOUBLE_QUOTED) {
            return kind.escape(s);
        }
        boolean singleLine = kind == StringKind.DOUBLE_QUOTED;
        StringBuilder b = new StringBuilder(s.length());
        GrStringUtil.escapeStringCharacters(s.length(), s, singleLine ? "\"" : "", singleLine, true, b);
        GrStringUtil.unescapeCharacters(b, singleLine ? "'" : "'\"", true);
        for (int i = b.length() - 2; i >= 0; --i) {
            char next;
            if (b.charAt(i) != '$' || (next = b.charAt(i + 1)) == '{' || Character.isLetter(next)) continue;
            b.insert(i, '\\');
        }
        if (b.charAt(b.length() - 1) == '$') {
            b.insert(b.length() - 1, '\\');
        }
        return b.toString();
    }

    @VisibleForTesting
    @Nullable
    public static StringKind findStringKind(PsiFile file, int startOffset, int endOffset) {
        StringKind endKind;
        if (startOffset == endOffset) {
            return GroovyLiteralCopyPasteProcessor.findStringKind(file, startOffset);
        }
        StringKind startKind = GroovyLiteralCopyPasteProcessor.findStringKind(file, startOffset);
        if (startKind == (endKind = GroovyLiteralCopyPasteProcessor.findStringKind(file, endOffset))) {
            return startKind;
        }
        return null;
    }

    @Nullable
    private static StringKind findStringKind(@NotNull PsiFile file, int offset) {
        PsiElement leaf = file.findElementAt(offset);
        if (leaf == null) {
            return null;
        }
        IElementType leafType = leaf.getNode().getElementType();
        int leafOffset = leaf.getTextOffset();
        if (offset == leafOffset) {
            if (leafType == GroovyElementTypes.GSTRING_END || leafType == GroovyElementTypes.SLASHY_END || leafType == GroovyElementTypes.DOLLAR_SLASHY_END) {
                PsiElement prevSibling = leaf.getPrevSibling();
                if (prevSibling != null) {
                    IElementType previousElementType = prevSibling.getNode().getElementType();
                    if (previousElementType == GroovyElementTypes.STRING_INJECTION) {
                        if (leafType == GroovyElementTypes.GSTRING_END) {
                            if (GroovyLiteralCopyPasteProcessor.isMultiline(leaf.getParent())) {
                                return StringKind.TRIPLE_DOUBLE_QUOTED;
                            }
                            return StringKind.DOUBLE_QUOTED;
                        }
                        if (leafType == GroovyElementTypes.SLASHY_END) {
                            return StringKind.SLASHY;
                        }
                        return StringKind.DOLLAR_SLASHY;
                    }
                    if (previousElementType == GroovyElementTypes.STRING_CONTENT) {
                        PsiElement contentLeaf = prevSibling.getFirstChild();
                        return GroovyLiteralCopyPasteProcessor.getStringKindByContentTokenType(contentLeaf, contentLeaf.getNode().getElementType());
                    }
                    if (previousElementType == GroovyElementTypes.DOLLAR_SLASHY_BEGIN) {
                        return StringKind.DOLLAR_SLASHY;
                    }
                    if (leafType != GroovyElementTypes.GSTRING_END) {
                        return GroovyLiteralCopyPasteProcessor.getStringKindByContentTokenType(leaf, previousElementType);
                    }
                }
            } else if (leafType == GroovyElementTypes.T_DOLLAR) {
                PsiElement parent2 = leaf.getParent();
                PsiElement gParent = parent2.getParent();
                return GroovyLiteralCopyPasteProcessor.getStringKindByStringElement(gParent);
            }
        }
        int leafEndOffset = leafOffset + leaf.getTextLength();
        if ((leafType == GroovyElementTypes.STRING_SQ || leafType == GroovyElementTypes.STRING_DQ) && leafOffset + 1 <= offset && offset <= leafEndOffset - 1) {
            return leafType == GroovyElementTypes.STRING_SQ ? StringKind.SINGLE_QUOTED : StringKind.DOUBLE_QUOTED;
        }
        if ((leafType == GroovyElementTypes.STRING_TSQ || leafType == GroovyElementTypes.STRING_TDQ) && leafOffset + 3 <= offset && offset <= leafEndOffset - 3) {
            return leafType == GroovyElementTypes.STRING_TSQ ? StringKind.TRIPLE_SINGLE_QUOTED : StringKind.TRIPLE_DOUBLE_QUOTED;
        }
        return GroovyLiteralCopyPasteProcessor.getStringKindByContentTokenType(leaf, leafType);
    }

    @Nullable
    private static StringKind getStringKindByStringElement(@NotNull PsiElement templateStringElement) {
        IElementType elementType = templateStringElement.getNode().getElementType();
        if (elementType == GroovyElementTypes.GSTRING) {
            return GroovyLiteralCopyPasteProcessor.isMultiline(templateStringElement) ? StringKind.TRIPLE_DOUBLE_QUOTED : StringKind.DOUBLE_QUOTED;
        }
        if (elementType == GroovyElementTypes.REGEX) {
            IElementType quoteType = templateStringElement.getFirstChild().getNode().getElementType();
            return quoteType == GroovyElementTypes.SLASHY_BEGIN ? StringKind.SLASHY : StringKind.DOLLAR_SLASHY;
        }
        if (elementType == GroovyElementTypes.SLASHY_LITERAL) {
            return StringKind.SLASHY;
        }
        if (elementType == GroovyElementTypes.DOLLAR_SLASHY_LITERAL) {
            return StringKind.DOLLAR_SLASHY;
        }
        return null;
    }

    @Nullable
    private static StringKind getStringKindByContentTokenType(PsiElement leaf, IElementType contentTokenType) {
        if (contentTokenType == GroovyElementTypes.GSTRING_CONTENT) {
            PsiElement parent2 = leaf.getParent();
            PsiElement gParent = parent2.getParent();
            if (GroovyLiteralCopyPasteProcessor.isMultiline(gParent)) {
                return StringKind.TRIPLE_DOUBLE_QUOTED;
            }
            return StringKind.DOUBLE_QUOTED;
        }
        if (contentTokenType == GroovyElementTypes.SLASHY_CONTENT) {
            return StringKind.SLASHY;
        }
        if (contentTokenType == GroovyElementTypes.DOLLAR_SLASHY_CONTENT) {
            return StringKind.DOLLAR_SLASHY;
        }
        return null;
    }

    private static boolean isMultiline(@NotNull PsiElement templateStringElement) {
        return templateStringElement.getFirstChild().textMatches((CharSequence)"\"\"\"");
    }

    @Nullable
    private static StringKind getStringKindByToken(@NotNull PsiElement token) {
        IElementType leafType = token.getNode().getElementType();
        if (leafType == GroovyElementTypes.STRING_SQ) {
            return StringKind.SINGLE_QUOTED;
        }
        if (leafType == GroovyElementTypes.STRING_DQ) {
            return StringKind.DOUBLE_QUOTED;
        }
        if (leafType == GroovyElementTypes.STRING_TSQ) {
            return StringKind.TRIPLE_SINGLE_QUOTED;
        }
        if (leafType == GroovyElementTypes.STRING_TDQ) {
            return StringKind.TRIPLE_DOUBLE_QUOTED;
        }
        return GroovyLiteralCopyPasteProcessor.getStringKindByContentTokenType(token, leafType);
    }

    protected String getLineBreaker(@NotNull PsiElement token) {
        throw new IllegalStateException("must not be called");
    }

    @NotNull
    protected String escapeCharCharacters(@NotNull String s, @NotNull PsiElement token) {
        throw new IllegalStateException("must not be called");
    }

    public String escapeAndSplit(String text, PsiElement token) {
        throw new IllegalStateException("must not be called");
    }

    @NotNull
    protected String escapeTextBlock(@NotNull String text, int offset, boolean escapeStartQuote, boolean escapeEndQuote) {
        throw new IllegalStateException("must not be called");
    }

    protected boolean isCharLiteral(@NotNull PsiElement token) {
        throw new IllegalStateException("must not be called");
    }

    protected boolean isStringLiteral(@NotNull PsiElement token) {
        throw new IllegalStateException("must not be called");
    }

    protected boolean isTextBlock(@NotNull PsiElement token) {
        throw new IllegalStateException("must not be called");
    }

    @Nullable
    protected PsiElement findLiteralTokenType(PsiFile file, int selectionStart, int selectionEnd) {
        throw new IllegalStateException("must not be called");
    }
}

