/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;

public final class ConfigureGroovyLibraryNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"configure.groovy.library");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        try {
            if (!file.getFileType().equals((Object)GroovyFileType.GROOVY_FILE_TYPE)) {
                return null;
            }
            if (StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle")) {
                return null;
            }
            if (CompilerManager.getInstance((Project)project).isExcludedFromCompilation(file)) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module == null) {
                return null;
            }
            if (ConfigureGroovyLibraryNotificationProvider.isMavenModule(module)) {
                return null;
            }
            for (GroovyFrameworkConfigNotification configNotification : (GroovyFrameworkConfigNotification[])GroovyFrameworkConfigNotification.EP_NAME.getExtensions()) {
                if (!configNotification.hasFrameworkStructure(module)) continue;
                if (!configNotification.hasFrameworkLibrary(module)) {
                    return (EditorNotificationPanel)configNotification.createConfigureNotificationPanel(module);
                }
                return null;
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean isMavenModule(@NotNull Module module) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (root.findChild("pom.xml") == null) continue;
            return true;
        }
        return false;
    }
}

