/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.cs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.cs.SpreadArgumentFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0017J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/cs/SpreadArgumentFix;", "Lorg/jetbrains/plugins/groovy/codeInspection/GroovyFix;", "size", "", "(I)V", "getSize", "()I", "doFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "genReplaceText", "", "element", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrSpreadArgument;", "generateFixLine", "varName", "generateVariableName", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "getFamilyName", "getName", "handleListLiteral", "intellij.groovy"})
public final class SpreadArgumentFix
extends GroovyFix {
    private final int size;

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        if (!(psiElement instanceof GrSpreadArgument)) {
            psiElement = null;
        }
        GrSpreadArgument grSpreadArgument = (GrSpreadArgument)psiElement;
        if (grSpreadArgument == null) {
            return;
        }
        GrSpreadArgument element = grSpreadArgument;
        GrArgumentList grArgumentList = (GrArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, GrArgumentList.class);
        if (grArgumentList == null) {
            return;
        }
        GrArgumentList grArgumentList2 = grArgumentList;
        String string = this.handleListLiteral(element);
        if (string == null) {
            string = this.genReplaceText(element);
        }
        if (string == null) {
            return;
        }
        String replaceText = string;
        GrArgumentList newArgumentList = GroovyPsiElementFactory.getInstance(element.getProject()).createArgumentListFromText(replaceText);
        grArgumentList2.replaceWithArgumentList(newArgumentList);
    }

    private final String handleListLiteral(GrSpreadArgument element) {
        GrExpression grExpression = element.getArgument();
        if (!(grExpression instanceof GrListOrMap)) {
            grExpression = null;
        }
        GrListOrMap grListOrMap = (GrListOrMap)grExpression;
        if (grListOrMap == null) {
            return null;
        }
        GrListOrMap grListOrMap2 = grListOrMap;
        if (grListOrMap2.isMap()) {
            return null;
        }
        return ArraysKt.joinToString$default((Object[])grListOrMap2.getInitializers(), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)handleListLiteral.1.INSTANCE, (int)24, null);
    }

    private final String genReplaceText(GrSpreadArgument element) {
        GrStatementOwner grStatementOwner = (GrStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrStatementOwner.class);
        if (grStatementOwner == null) {
            return null;
        }
        GrStatementOwner grStatementOwner2 = grStatementOwner;
        PsiElement psiElement = PsiTreeUtil.findPrevParent((PsiElement)grStatementOwner2, (PsiElement)element);
        if (!(psiElement instanceof GrStatement)) {
            psiElement = null;
        }
        GrStatement grStatement = (GrStatement)psiElement;
        if (grStatement == null) {
            return null;
        }
        GrStatement prevStatement = grStatement;
        GrExpression expression = element.getArgument();
        String initializer = expression.getText();
        if (!(expression instanceof GrReferenceExpression) || !(((GrReferenceExpression)expression).resolve() instanceof GrVariable)) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
            String fixVariableName = this.generateVariableName(element);
            GrStatement varDefinition = factory.createStatementFromText("def " + fixVariableName + " = " + initializer);
            grStatementOwner2.addStatementBefore(varDefinition, prevStatement);
            initializer = fixVariableName;
        }
        return this.generateFixLine(initializer);
    }

    private final String generateVariableName(GrExpression expression) {
        String[] suggestedNames;
        DefaultGroovyVariableNameValidator validator = new DefaultGroovyVariableNameValidator(expression);
        String[] stringArray = suggestedNames = GroovyNameSuggestionUtil.suggestVariableNameByType(expression.getType(), validator);
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        return !(stringArray2.length == 0) ? suggestedNames[0] : "storedList";
    }

    private final String generateFixLine(String varName) {
        int n = 0;
        return CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(n, this.size - 1)), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(varName){
            final /* synthetic */ String $varName;

            @NotNull
            public final CharSequence invoke(int it) {
                return this.$varName + '[' + it + ']';
            }
            {
                this.$varName = string;
                super(1);
            }
        }), (int)24, null);
    }

    @NotNull
    public String getName() {
        return GroovyBundle.message("replace.with.get.at", new Object[0]);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("replace.with.get.at", new Object[0]);
    }

    public final int getSize() {
        return this.size;
    }

    public SpreadArgumentFix(int size) {
        this.size = size;
    }
}

