/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GrChangeVariableType
extends GroovyFix {
    private static final Logger LOG = Logger.getInstance(GrChangeVariableType.class);
    private final String myType;
    private final String myName;

    public GrChangeVariableType(PsiType type2, String name) {
        this.myType = type2.getCanonicalText();
        this.myName = name;
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent2 = element.getParent();
        try {
            PsiElement resolved;
            PsiType type2 = JavaPsiFacade.getElementFactory((Project)project).createTypeFromText(this.myType, element);
            if (parent2 instanceof GrVariable) {
                ((GrVariable)parent2).setType(type2);
            } else if (element instanceof GrReferenceExpression && parent2 instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent2).getLValue() == element && (resolved = ((GrReferenceExpression)element).resolve()) instanceof GrVariable && !(resolved instanceof GrParameter)) {
                ((GrVariable)resolved).setType(type2);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getName() {
        return GroovyInspectionBundle.message("change.lvalue.type", this.myName, this.myType);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Change variable type";
    }
}

