/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrCastFix
extends GroovyFix {
    private final PsiType myExpectedType;
    private final boolean mySafe;
    @NotNull
    private final SmartPsiElementPointer<GrExpression> pointer;
    @NotNull
    private final String myName;

    public GrCastFix(PsiType expectedType, GrExpression expression) {
        this(expectedType, expression, true);
    }

    public GrCastFix(PsiType expectedType, GrExpression expression, boolean safe) {
        this(expectedType, expression, safe, "Cast to " + expectedType.getPresentableText());
    }

    public GrCastFix(PsiType expectedType, GrExpression expression, boolean safe, @NotNull String name) {
        this.mySafe = safe;
        this.myName = name;
        this.myExpectedType = PsiImplUtil.normalizeWildcardTypeByPosition(expectedType, expression);
        this.pointer = SmartPointerManager.getInstance((Project)expression.getProject()).createSmartPsiElementPointer((PsiElement)expression);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        GrExpression expression = (GrExpression)this.pointer.getElement();
        if (expression == null) {
            return;
        }
        if (this.mySafe) {
            GrCastFix.doSafeCast(project, this.myExpectedType, expression);
        } else {
            GrCastFix.doCast(project, this.myExpectedType, expression);
        }
    }

    private static void doCast(Project project, PsiType type2, GrExpression expr) {
        if (!type2.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrTypeCastExpression cast = (GrTypeCastExpression)factory.createExpressionFromText("(String)foo");
        GrTypeElement typeElement = factory.createTypeElement(type2);
        GrExpression operand = cast.getOperand();
        if (operand == null) {
            return;
        }
        operand.replaceWithExpression(expr, true);
        cast.getCastTypeElement().replace(typeElement);
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    @ApiStatus.Internal
    public static void doSafeCast(@NotNull Project project, @NotNull PsiType type2, @NotNull GrExpression expr) {
        if (!type2.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrSafeCastExpression cast = (GrSafeCastExpression)factory.createExpressionFromText("foo as String");
        GrTypeElement typeElement = factory.createTypeElement(type2);
        cast.getOperand().replaceWithExpression(expr, true);
        GrTypeElement castTypeElement = cast.getCastTypeElement();
        if (castTypeElement != null) {
            castTypeElement.replace(typeElement);
        }
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Add cast";
    }
}

