/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public class CreateFieldFromConstructorLabelFix
extends GroovyFix {
    private final CreateFieldFix myFix;
    private final SmartPsiElementPointer<GrNamedArgument> myNamedArgumentPointer;

    public CreateFieldFromConstructorLabelFix(@NotNull GrTypeDefinition targetClass, @NotNull GrNamedArgument namedArgument) {
        this.myFix = new CreateFieldFix(targetClass);
        this.myNamedArgumentPointer = PointersKt.createSmartPointer((PsiElement)namedArgument);
    }

    @Nullable
    private String getFieldName() {
        GrNamedArgument namedArgument = (GrNamedArgument)this.myNamedArgumentPointer.getElement();
        if (namedArgument == null) {
            return null;
        }
        GrArgumentLabel label = namedArgument.getLabel();
        assert (label != null);
        return label.getName();
    }

    private static TypeConstraint[] calculateTypeConstrains(@NotNull GrNamedArgument namedArgument) {
        GrExpression expression = namedArgument.getExpression();
        PsiType type2 = null;
        if (expression != null) {
            type2 = expression.getType();
        }
        if (type2 != null) {
            return new TypeConstraint[]{SupertypeConstraint.create(type2, type2)};
        }
        return TypeConstraint.EMPTY_ARRAY;
    }

    @NotNull
    public String getName() {
        return GroovyBundle.message("create.field.from.usage", this.getFieldName());
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Create field";
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        GrNamedArgument namedArgument = (GrNamedArgument)this.myNamedArgumentPointer.getElement();
        if (namedArgument == null) {
            return;
        }
        String fieldName = this.getFieldName();
        if (fieldName == null) {
            return;
        }
        this.myFix.doFix(project, ArrayUtilRt.EMPTY_STRING_ARRAY, fieldName, CreateFieldFromConstructorLabelFix.calculateTypeConstrains(namedArgument), namedArgument);
    }
}

