/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.IntroduceTargetChooser;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class DumpGroovyControlFlowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        PsiFile psiFile = (PsiFile)e.getDataContext().getData(CommonDataKeys.PSI_FILE);
        if (!(psiFile instanceof GroovyFile)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        List<GrControlFlowOwner> controlFlowOwners = DumpGroovyControlFlowAction.collectControlFlowOwners(psiFile, offset);
        if (controlFlowOwners.isEmpty()) {
            return;
        }
        if (controlFlowOwners.size() == 1) {
            DumpGroovyControlFlowAction.passInner(controlFlowOwners.get(0));
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, controlFlowOwners, (Pass)new Pass<GrControlFlowOwner>(){

                public void pass(GrControlFlowOwner grExpression) {
                    DumpGroovyControlFlowAction.passInner(grExpression);
                }
            }, flowOwner -> flowOwner.getText());
        }
    }

    private static List<GrControlFlowOwner> collectControlFlowOwners(PsiFile file, int offset) {
        PsiElement elementAtCaret = file.findElementAt(offset);
        ArrayList<GrControlFlowOwner> result2 = new ArrayList<GrControlFlowOwner>();
        GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(elementAtCaret);
        while (owner != null && !result2.contains(owner)) {
            result2.add(owner);
            owner = ControlFlowUtils.findControlFlowOwner(owner);
        }
        return result2;
    }

    private static void passInner(GrControlFlowOwner owner) {
        System.out.println(owner.getText());
        System.out.println(ControlFlowUtils.dumpControlFlow(owner.getControlFlow()));
    }
}

