/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.util.lang.JavaVersion;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleJvmProviderId;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionContext;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;
import org.jetbrains.plugins.gradle.util.GradleProperties;
import org.jetbrains.plugins.gradle.util.GradlePropertiesUtil;
import org.jetbrains.plugins.gradle.util.JavaHomeValidationStatus;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0016*\u00020\u0017H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0016*\u00020\u0017H\u0002\u001a\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0014*\u00020\u0017H\u0002\u00a8\u0006\u001b"}, d2={"findGradleVersion", "Lorg/gradle/util/GradleVersion;", "project", "Lcom/intellij/openapi/project/Project;", "findRegisteredSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "getGradleJvmLookupProvider", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "resolveProjectJdk", "setupGradleJvm", "", "gradleVersion", "suggestGradleVersion", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "updateGradleJvm", "externalProjectPath", "", "canUseGradleJavaHomeJdk", "", "Lorg/jetbrains/plugins/gradle/util/GradleJvmResolutionContext;", "canUseJavaHomeJdk", "canUseProjectSdk", "findGradleJvm", "intellij.gradle.common"})
@JvmName(name="GradleJvmResolutionUtil")
@ApiStatus.Internal
public final class GradleJvmResolutionUtil {
    @NotNull
    public static final SdkLookupProvider getGradleJvmLookupProvider(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
        return SdkLookupProvider.Companion.getInstance(project, (SdkLookupProvider.Id)new GradleJvmProviderId(projectSettings));
    }

    public static final void setupGradleJvm(@NotNull Project project, @NotNull GradleProjectSettings projectSettings, @NotNull GradleVersion gradleVersion) {
        GradleJvmResolutionContext resolutionContext = new GradleJvmResolutionContext(project, Paths.get(projectSettings.getExternalProjectPath(), new String[0]), gradleVersion);
        projectSettings.setGradleJvm(GradleJvmResolutionUtil.findGradleJvm(resolutionContext));
        if (projectSettings.getGradleJvm() != null) {
            return;
        }
        if (GradleJvmResolutionUtil.canUseProjectSdk(resolutionContext)) {
            projectSettings.setGradleJvm("#USE_PROJECT_JDK");
        } else if (GradleJvmResolutionUtil.canUseGradleJavaHomeJdk(resolutionContext)) {
            projectSettings.setGradleJvm("#GRADLE_JAVA_HOME");
        } else if (GradleJvmResolutionUtil.canUseJavaHomeJdk(resolutionContext)) {
            projectSettings.setGradleJvm("#JAVA_HOME");
        } else {
            GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, projectSettings).newLookupBuilder().withVersionFilter((Function1)new Function1<String, Boolean>(gradleVersion){
                final /* synthetic */ GradleVersion $gradleVersion;

                public final boolean invoke(@NotNull String it) {
                    return GradleJvmValidationUtil.isSupported(this.$gradleVersion, it);
                }
                {
                    this.$gradleVersion = gradleVersion;
                    super(1);
                }
            }).withSdkType(ExternalSystemJdkUtil.getJavaSdkType()).withSdkHomeFilter((Function1)setupGradleJvm.2.INSTANCE).onSdkNameResolved((Function1)new Function1<Sdk, Unit>(projectSettings){
                final /* synthetic */ GradleProjectSettings $projectSettings;

                public final void invoke(@Nullable Sdk sdk) {
                    Sdk fakeSdk;
                    Sdk sdk2;
                    Sdk sdk3 = sdk;
                    if (sdk3 != null) {
                        Sdk sdk4 = sdk3;
                        boolean bl = false;
                        boolean bl2 = false;
                        Sdk p1 = sdk4;
                        boolean bl3 = false;
                        sdk2 = GradleJvmResolutionUtil.access$findRegisteredSdk(p1);
                    } else {
                        sdk2 = fakeSdk = null;
                    }
                    if (fakeSdk != null && this.$projectSettings.getGradleJvm() == null) {
                        this.$projectSettings.setGradleJvm(fakeSdk.getName());
                    }
                }
                {
                    this.$projectSettings = gradleProjectSettings;
                    super(1);
                }
            }).onSdkResolved((Function1)new Function1<Sdk, Unit>(projectSettings){
                final /* synthetic */ GradleProjectSettings $projectSettings;

                public final void invoke(@Nullable Sdk sdk) {
                    if (this.$projectSettings.getGradleJvm() == null) {
                        Sdk sdk2 = sdk;
                        this.$projectSettings.setGradleJvm(sdk2 != null ? sdk2.getName() : null);
                    }
                }
                {
                    this.$projectSettings = gradleProjectSettings;
                    super(1);
                }
            }).executeLookup();
        }
    }

    public static final void updateGradleJvm(@NotNull Project project, @NotNull String externalProjectPath) {
        GradleSettings settings2 = GradleSettings.getInstance(project);
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(externalProjectPath);
        if (gradleProjectSettings == null) {
            return;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        String string = projectSettings.getGradleJvm();
        if (string == null) {
            return;
        }
        String gradleJvm = string;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Sdk sdk = projectRootManager.getProjectSdk();
        if (sdk == null) {
            return;
        }
        Sdk projectSdk = sdk;
        if (Intrinsics.areEqual((Object)projectSdk.getName(), (Object)gradleJvm) ^ true) {
            return;
        }
        projectSettings.setGradleJvm("#USE_PROJECT_JDK");
    }

    @Nullable
    public static final GradleVersion suggestGradleVersion(@NotNull Project project) {
        GradleVersion gradleVersion = GradleJvmResolutionUtil.findGradleVersion(project);
        if (gradleVersion != null) {
            return gradleVersion;
        }
        Sdk sdk = GradleJvmResolutionUtil.resolveProjectJdk(project);
        if (sdk == null) {
            return null;
        }
        Sdk projectJdk = sdk;
        if (!ExternalSystemJdkUtil.isValidJdk((Sdk)projectJdk)) {
            return null;
        }
        JavaVersion javaVersion = JavaVersion.tryParse((String)projectJdk.getVersionString());
        if (javaVersion == null) {
            return null;
        }
        JavaVersion javaVersion2 = javaVersion;
        return GradleJvmResolutionUtil.suggestGradleVersion(javaVersion2);
    }

    private static final GradleVersion suggestGradleVersion(JavaVersion javaVersion) {
        int version = javaVersion.feature;
        return version >= 8 ? GradleVersion.version((String)"6.3") : (version == 7 ? GradleVersion.version((String)"4.1") : (version == 6 ? GradleVersion.version((String)"3.0") : null));
    }

    private static final GradleVersion findGradleVersion(Project project) {
        GradleSettings settings2 = GradleSettings.getInstance(project);
        return (GradleVersion)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)settings2.getLinkedProjectsSettings()), (Function1)findGradleVersion.1.INSTANCE));
    }

    private static final boolean canUseGradleJavaHomeJdk(GradleJvmResolutionContext $this$canUseGradleJavaHomeJdk) {
        GradleProperties properties = GradlePropertiesUtil.getGradleProperties($this$canUseGradleJavaHomeJdk.getExternalProjectPath());
        GradleProperties.GradleProperty<String> gradleProperty = properties.getJavaHomeProperty();
        String javaHome = gradleProperty != null ? gradleProperty.getValue() : null;
        JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome($this$canUseGradleJavaHomeJdk.getGradleVersion(), javaHome);
        return validationStatus instanceof JavaHomeValidationStatus.Success;
    }

    private static final boolean canUseJavaHomeJdk(GradleJvmResolutionContext $this$canUseJavaHomeJdk) {
        String javaHome = ExternalSystemJdkUtil.getJavaHome();
        JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome($this$canUseJavaHomeJdk.getGradleVersion(), javaHome);
        return validationStatus instanceof JavaHomeValidationStatus.Success;
    }

    private static final String findGradleJvm(GradleJvmResolutionContext $this$findGradleJvm) {
        GradleSettings settings2 = GradleSettings.getInstance($this$findGradleJvm.getProject());
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)settings2.getLinkedProjectsSettings()), (Function1)findGradleJvm.1.INSTANCE));
    }

    private static final boolean canUseProjectSdk(GradleJvmResolutionContext $this$canUseProjectSdk) {
        Sdk sdk = GradleJvmResolutionUtil.resolveProjectJdk($this$canUseProjectSdk.getProject());
        if (sdk == null) {
            return false;
        }
        Sdk projectJdk = sdk;
        if (!ExternalSystemJdkUtil.isValidJdk((Sdk)projectJdk)) {
            return false;
        }
        String string = projectJdk.getVersionString();
        if (string == null) {
            return false;
        }
        String versionString = string;
        return GradleJvmValidationUtil.isSupported($this$canUseProjectSdk.getGradleVersion(), versionString);
    }

    private static final Sdk resolveProjectJdk(Project project) {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Sdk sdk = projectRootManager.getProjectSdk();
        if (sdk == null) {
            return null;
        }
        Sdk projectSdk = sdk;
        return ExternalSystemJdkUtil.resolveDependentJdk((Sdk)projectSdk);
    }

    private static final Sdk findRegisteredSdk(Sdk sdk) {
        boolean $i$f$runReadAction = false;
        return (Sdk)ApplicationManager.getApplication().runReadAction(new Computable<T>(sdk){
            final /* synthetic */ Sdk $sdk$inlined;
            {
                this.$sdk$inlined = sdk;
            }

            public final T compute() {
                boolean bl = false;
                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                return (T)projectJdkTable.findJdk(this.$sdk$inlined.getName(), this.$sdk$inlined.getSdkType().getName());
            }
        });
    }

    public static final /* synthetic */ Sdk access$findRegisteredSdk(Sdk sdk) {
        return GradleJvmResolutionUtil.findRegisteredSdk(sdk);
    }
}

