/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.ui;

import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class MatrixControlBuilder {
    private final DefaultTableModel myModel = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    private final JBTable myTable;
    private final JComponent myResult;
    private final int[] myColumnWidths;
    private final FontMetrics myFontMetrics;

    public MatrixControlBuilder(String ... columns) {
        this.myModel.addColumn("");
        for (String string : columns) {
            this.myModel.addColumn(string);
        }
        this.myTable = new JBTable(this.myModel){

            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        this.myTable.setFocusable(false);
        this.myTable.setStriped(true);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        int max = this.myTable.getColumnCount();
        for (int i2 = 0; i2 < max; ++i2) {
            TableCellRenderer headerRenderer;
            TableColumn tableColumn = this.myTable.getColumnModel().getColumn(i2);
            if (i2 > 0) {
                tableColumn.setCellRenderer(renderer);
            }
            if (!((headerRenderer = tableColumn.getHeaderRenderer()) instanceof JLabel)) continue;
            ((JLabel)((Object)headerRenderer)).setHorizontalAlignment(0);
        }
        this.myResult = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        this.myColumnWidths = new int[columns.length + 1];
        this.myFontMetrics = this.myTable.getFontMetrics(this.myTable.getFont());
        for (int i2 = 0; i2 < columns.length; ++i2) {
            this.myColumnWidths[i2 + 1] = this.myFontMetrics.stringWidth(columns[i2]);
        }
    }

    public void addRow(@NotNull String name, Object ... values) throws IllegalArgumentException {
        if (values.length != this.myModel.getColumnCount() - 1) {
            StringBuilder columns = new StringBuilder();
            int max = this.myModel.getColumnCount();
            for (int i2 = 1; i2 < max; ++i2) {
                columns.append(this.myModel.getColumnName(i2)).append(", ");
            }
            if (columns.length() > 2) {
                columns.setLength(columns.length() - 2);
            }
            throw new IllegalArgumentException(String.format("Can't add row '%s' to the matrix control. Reason: the row specifies incorrect number of values (%d, expected %d). Registered columns: %s. Given values: %s", name, values.length, this.myModel.getColumnCount() - 1, columns, Arrays.toString(values)));
        }
        Object[] rowData = new Object[values.length + 1];
        rowData[0] = name;
        System.arraycopy(values, 0, rowData, 1, values.length);
        this.myModel.addRow(rowData);
        for (int i3 = 0; i3 < rowData.length; ++i3) {
            this.myColumnWidths[i3] = Math.max(this.myFontMetrics.stringWidth(rowData[i3].toString()), this.myColumnWidths[i3]);
        }
    }

    @NotNull
    public JComponent build() {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int i2 = 0; i2 < this.myColumnWidths.length; ++i2) {
            columnModel.getColumn(i2).setMinWidth(this.myColumnWidths[i2] + 4);
        }
        return this.myResult;
    }
}

