/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.DelegatingGradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.settings.GradleSettingsMigration;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

@State(name="GradleSettings", storages={@Storage(value="gradle.xml")})
public class GradleSettings
extends AbstractExternalSystemSettings<GradleSettings, GradleProjectSettings, GradleSettingsListener>
implements PersistentStateComponent<MyState> {
    private boolean isOfflineMode = false;

    public GradleSettings(@NotNull Project project) {
        super(GradleSettingsListener.TOPIC, project);
    }

    @NotNull
    public static GradleSettings getInstance(@NotNull Project project) {
        return (GradleSettings)((Object)project.getService(GradleSettings.class));
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<GradleProjectSettings> listener2) {
        this.doSubscribe(new DelegatingGradleSettingsListenerAdapter(listener2), (Disposable)this.getProject());
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<GradleProjectSettings> listener2, @NotNull Disposable parentDisposable) {
        this.doSubscribe(new DelegatingGradleSettingsListenerAdapter(listener2), parentDisposable);
    }

    protected void copyExtraSettingsFrom(@NotNull GradleSettings settings2) {
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        this.fillState(state);
        state.setOfflineMode(this.isOfflineWork());
        return state;
    }

    public void loadState(@NotNull MyState state) {
        super.loadState((AbstractExternalSystemSettings.State)state);
        this.setOfflineWork(state.isOfflineMode());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        GradleSettingsMigration migration = (GradleSettingsMigration)this.getProject().getService(GradleSettingsMigration.class);
        if (migration.getMigrationVersion() < 1) {
            migration.setMigrationVersion(1);
            GradleSettingsMigration.LegacyDefaultGradleProjectSettings.MyState legacyProjectDefaults = ((GradleSettingsMigration.LegacyDefaultGradleProjectSettings)this.getProject().getService(GradleSettingsMigration.LegacyDefaultGradleProjectSettings.class)).getState();
            if (legacyProjectDefaults != null) {
                for (GradleProjectSettings each : this.getLinkedProjectsSettings()) {
                    if (each.getDirectDelegatedBuild() == null) {
                        each.setDelegatedBuild(legacyProjectDefaults.delegatedBuild);
                    }
                    if (each.getDirectTestRunner() != null) continue;
                    each.setTestRunner(legacyProjectDefaults.testRunner);
                }
            }
        }
    }

    @Nullable
    public String getServiceDirectoryPath() {
        return GradleSystemSettings.getInstance().getServiceDirectoryPath();
    }

    public void setServiceDirectoryPath(@Nullable String newPath) {
        String myServiceDirectoryPath = GradleSystemSettings.getInstance().getServiceDirectoryPath();
        if (!Objects.equals(myServiceDirectoryPath, newPath)) {
            GradleSystemSettings.getInstance().setServiceDirectoryPath(newPath);
            ((GradleSettingsListener)this.getPublisher()).onServiceDirectoryPathChange(myServiceDirectoryPath, newPath);
        }
    }

    @Nullable
    public String getGradleVmOptions() {
        return GradleSystemSettings.getInstance().getGradleVmOptions();
    }

    public void setGradleVmOptions(@Nullable String gradleVmOptions) {
        String myGradleVmOptions = GradleSystemSettings.getInstance().getGradleVmOptions();
        if (!Objects.equals(myGradleVmOptions, gradleVmOptions)) {
            GradleSystemSettings.getInstance().setGradleVmOptions(gradleVmOptions);
            ((GradleSettingsListener)this.getPublisher()).onGradleVmOptionsChange(myGradleVmOptions, gradleVmOptions);
        }
    }

    public boolean isOfflineWork() {
        return this.isOfflineMode;
    }

    public void setOfflineWork(boolean isOfflineMode) {
        this.isOfflineMode = isOfflineMode;
    }

    public boolean getStoreProjectFilesExternally() {
        return ExternalStorageConfigurationManager.getInstance((Project)this.getProject()).isEnabled();
    }

    public void setStoreProjectFilesExternally(boolean value) {
        ExternalProjectsManagerImpl.getInstance((Project)this.getProject()).setStoreExternally(value);
    }

    protected void checkSettings(@NotNull GradleProjectSettings old, @NotNull GradleProjectSettings current) {
        if (!Objects.equals(old.getGradleHome(), current.getGradleHome())) {
            ((GradleSettingsListener)this.getPublisher()).onGradleHomeChange(old.getGradleHome(), current.getGradleHome(), current.getExternalProjectPath());
        }
        if (old.getDistributionType() != current.getDistributionType()) {
            ((GradleSettingsListener)this.getPublisher()).onGradleDistributionTypeChange(current.getDistributionType(), current.getExternalProjectPath());
        }
        if (old.isResolveModulePerSourceSet() != current.isResolveModulePerSourceSet()) {
            ExternalProjectsManager.getInstance((Project)this.getProject()).getExternalProjectsWatcher().markDirty(current.getExternalProjectPath());
        }
        if (!Comparing.equal((Object)old.getDelegatedBuild(), (Object)current.getDelegatedBuild())) {
            boolean delegatedBuild = GradleProjectSettings.isDelegatedBuildEnabled(this.getProject(), current.getExternalProjectPath());
            ((GradleSettingsListener)this.getPublisher()).onBuildDelegationChange(delegatedBuild, current.getExternalProjectPath());
        }
        if (!Comparing.equal((Object)((Object)old.getTestRunner()), (Object)((Object)current.getTestRunner()))) {
            TestRunner testRunner = GradleProjectSettings.getTestRunner(this.getProject(), current.getExternalProjectPath());
            ((GradleSettingsListener)this.getPublisher()).onTestRunnerChange(testRunner, current.getExternalProjectPath());
        }
    }

    public static class MyState
    implements AbstractExternalSystemSettings.State<GradleProjectSettings> {
        private final Set<GradleProjectSettings> myProjectSettings = new TreeSet<GradleProjectSettings>();
        private boolean isOfflineMode = false;

        @XCollection(elementTypes={GradleProjectSettings.class})
        public Set<GradleProjectSettings> getLinkedExternalProjectsSettings() {
            return this.myProjectSettings;
        }

        public void setLinkedExternalProjectsSettings(Set<GradleProjectSettings> settings2) {
            if (settings2 != null) {
                this.myProjectSettings.addAll(settings2);
            }
        }

        public boolean isOfflineMode() {
            return this.isOfflineMode;
        }

        public void setOfflineMode(boolean isOfflineMode) {
            this.isOfflineMode = isOfflineMode;
        }
    }
}

