/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@State(name="GradleLocalSettings", storages={@Storage(value="$CACHE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public class GradleLocalSettings
extends AbstractExternalSystemLocalSettings<MyState>
implements PersistentStateComponent<MyState> {
    public GradleLocalSettings(@NotNull Project project) {
        super(GradleConstants.SYSTEM_ID, project, (AbstractExternalSystemLocalSettings.State)new MyState());
    }

    @NotNull
    public static GradleLocalSettings getInstance(@NotNull Project project) {
        return (GradleLocalSettings)((Object)ServiceManager.getService((Project)project, GradleLocalSettings.class));
    }

    @Nullable
    public String getGradleHome(String linkedProjectPath) {
        return (String)ContainerUtil.notNullize(((MyState)this.state).myGradleHomes).get(linkedProjectPath);
    }

    @Nullable
    public String getGradleVersion(String linkedProjectPath) {
        return (String)ContainerUtil.notNullize(((MyState)this.state).myGradleVersions).get(linkedProjectPath);
    }

    public void setGradleHome(@NotNull String linkedProjectPath, @NotNull String gradleHome) {
        if (((MyState)this.state).myGradleHomes == null) {
            ((MyState)this.state).myGradleHomes = new THashMap();
        }
        ((MyState)this.state).myGradleHomes.put(linkedProjectPath, gradleHome);
        if (((MyState)this.state).myGradleVersions == null) {
            ((MyState)this.state).myGradleVersions = new THashMap();
        }
        ((MyState)this.state).myGradleVersions.put(linkedProjectPath, GradleInstallationManager.getGradleVersion(gradleHome));
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        super.forgetExternalProjects(linkedProjectPathsToForget);
        for (String path : linkedProjectPathsToForget) {
            if (((MyState)this.state).myGradleHomes != null) {
                ((MyState)this.state).myGradleHomes.remove(path);
            }
            if (((MyState)this.state).myGradleVersions == null) continue;
            ((MyState)this.state).myGradleVersions.remove(path);
        }
    }

    public void loadState(@NotNull MyState state) {
        super.loadState((AbstractExternalSystemLocalSettings.State)state);
    }

    public static class MyState
    extends AbstractExternalSystemLocalSettings.State {
        public Map<String, String> myGradleHomes;
        public Map<String, String> myGradleVersions;
    }
}

