/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.StatusEvent;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.tooling.Message;

public class GradleProgressListener
implements org.gradle.tooling.ProgressListener,
ProgressListener {
    private static final Logger LOG = Logger.getInstance(GradleProgressListener.class);
    private final ExternalSystemTaskNotificationListener myListener;
    private final ExternalSystemTaskId myTaskId;
    private final Map<Object, Long> myStatusEventIds = new HashMap<Object, Long>();
    private final Map<Object, Couple<Long>> myDownloadStatusEventIds = new HashMap<Object, Couple<Long>>();
    private final String myOperationId;
    private static final String STARTING_GRADLE_DAEMON_EVENT = "Starting Gradle Daemon";
    private ExternalSystemTaskNotificationEvent myLastStatusChange = null;

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId taskId) {
        this(listener2, taskId, null);
    }

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId taskId, @Nullable String buildRootDir) {
        this.myListener = listener2;
        this.myTaskId = taskId;
        this.myOperationId = taskId.hashCode() + FileUtil.pathHashCode((String)(buildRootDir == null ? UUID.randomUUID().toString() : buildRootDir)) + "_";
    }

    public void statusChanged(ProgressEvent event) {
        GradleProgressEventConverter.EventId eventId = GradleProgressEventConverter.getEventId(event, this.myOperationId);
        ExternalSystemTaskNotificationEvent progressBuildEvent = GradleProgressEventConverter.createProgressBuildEvent(this.myTaskId, this.myTaskId, event);
        this.sendProgressToOutputIfNeeded(event);
        if (progressBuildEvent != null && event instanceof StatusEvent) {
            this.myListener.onStatusChange(progressBuildEvent);
        }
        this.maybeUpdateTaskStatus(progressBuildEvent);
        if (event instanceof TaskProgressEvent) {
            ExternalSystemTaskNotificationEvent notificationEvent = GradleProgressEventConverter.convert(this.myTaskId, event, new GradleProgressEventConverter.EventId(eventId.id, this.myTaskId));
            this.myListener.onStatusChange(notificationEvent);
        }
    }

    public void statusChanged(org.gradle.tooling.ProgressEvent event) {
        String eventDescription = event.getDescription();
        if (this.maybeReportModelBuilderMessage(eventDescription)) {
            return;
        }
        ExternalSystemTaskNotificationEvent progressBuildEvent = GradleProgressEventConverter.legacyCreateProgressBuildEvent(this.myTaskId, this.myTaskId, eventDescription);
        this.maybeUpdateTaskStatus(progressBuildEvent);
        this.myListener.onStatusChange(new ExternalSystemTaskNotificationEvent(this.myTaskId, eventDescription));
        this.reportGradleDaemonStartingEvent(eventDescription);
    }

    private boolean maybeReportModelBuilderMessage(String eventDescription) {
        if (!eventDescription.startsWith("ModelBuilderService message: ")) {
            return false;
        }
        try {
            Message message = (Message)new GsonBuilder().create().fromJson(StringUtil.substringAfter((String)eventDescription, (String)"ModelBuilderService message: "), Message.class);
            MessageEvent.Kind kind = MessageEvent.Kind.valueOf((String)message.getKind().name());
            Message.FilePosition messageFilePosition = message.getFilePosition();
            final FilePosition filePosition = messageFilePosition == null ? null : new FilePosition(new File(messageFilePosition.getFilePath()), messageFilePosition.getLine(), messageFilePosition.getColumn());
            MessageEventImpl messageEvent = new MessageEventImpl(this.myTaskId, kind, message.getGroup(), message.getTitle(), message.getText()){

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project) {
                    if (filePosition == null) {
                        return null;
                    }
                    return new FileNavigatable(project, filePosition);
                }
            };
            this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(this.myTaskId, (BuildEvent)messageEvent));
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to report model builder message using event '" + eventDescription + "'", (Throwable)e);
            return false;
        }
    }

    private void maybeUpdateTaskStatus(@Nullable ExternalSystemTaskNotificationEvent progressBuildEvent) {
        if (progressBuildEvent != null && !progressBuildEvent.equals((Object)this.myLastStatusChange)) {
            this.myListener.onStatusChange(progressBuildEvent);
            this.myLastStatusChange = progressBuildEvent;
        }
    }

    private void sendProgressToOutputIfNeeded(ProgressEvent progressEvent) {
        String operationName = progressEvent.getDescriptor().getName();
        if (progressEvent instanceof StatusEvent) {
            StatusEvent statusEvent = (StatusEvent)progressEvent;
            if ("bytes".equals(statusEvent.getUnit())) {
                Couple<Long> oldProgress = this.myDownloadStatusEventIds.get(operationName);
                if (oldProgress == null) {
                    String totalSizeInfo = statusEvent.getTotal() > 0L ? " (" + StringUtil.formatFileSize((long)statusEvent.getTotal()) + ")" : "";
                    this.myListener.onTaskOutput(this.myTaskId, operationName + totalSizeInfo, true);
                    this.myDownloadStatusEventIds.put(operationName, (Couple<Long>)Couple.of((Object)statusEvent.getTotal(), (Object)statusEvent.getProgress()));
                } else if (!((Long)oldProgress.second).equals(statusEvent.getProgress())) {
                    this.myDownloadStatusEventIds.put(operationName, (Couple<Long>)Couple.of((Object)statusEvent.getTotal(), (Object)statusEvent.getProgress()));
                    if (statusEvent.getTotal() > 0L) {
                        String sizeInfo = " (" + StringUtil.formatFileSize((long)statusEvent.getProgress()) + "/ " + StringUtil.formatFileSize((long)statusEvent.getTotal()) + ")";
                        this.myListener.onTaskOutput(this.myTaskId, "\r" + operationName + sizeInfo, true);
                    } else {
                        this.myListener.onTaskOutput(this.myTaskId, StringUtil.formatFileSize((long)statusEvent.getProgress()) + "\n", true);
                    }
                }
            }
        } else if (progressEvent instanceof FinishEvent) {
            FinishEvent finishEvent = (FinishEvent)progressEvent;
            Couple<Long> currentProgress = this.myDownloadStatusEventIds.remove(operationName);
            if (currentProgress != null) {
                OperationResult operationResult = finishEvent.getResult();
                String duration = StringUtil.formatDuration((long)(operationResult.getEndTime() - operationResult.getStartTime()));
                String text = String.format("\r%s, took %s (%s)\n", finishEvent.getDisplayName(), duration, StringUtil.formatFileSize((long)((Long)currentProgress.first)));
                this.myListener.onTaskOutput(this.myTaskId, text, true);
                if (!((Long)currentProgress.first).equals(currentProgress.second)) {
                    ProgressBuildEventImpl progressBuildEvent = new ProgressBuildEventImpl((Object)this.myTaskId, (Object)this.myTaskId, System.currentTimeMillis(), operationName, ((Long)currentProgress.first).longValue(), ((Long)currentProgress.first).longValue(), "bytes");
                    this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(this.myTaskId, (BuildEvent)progressBuildEvent));
                }
            }
        }
    }

    private void reportGradleDaemonStartingEvent(String eventDescription) {
        if (StringUtil.equals((CharSequence)STARTING_GRADLE_DAEMON_EVENT, (CharSequence)eventDescription)) {
            long eventTime = System.currentTimeMillis();
            Long startTime = this.myStatusEventIds.remove(eventDescription);
            if (startTime == null) {
                this.myListener.onTaskOutput(this.myTaskId, "Starting Gradle Daemon...\n", true);
                this.myStatusEventIds.put(eventDescription, eventTime);
            } else {
                String duration = StringUtil.formatDuration((long)(eventTime - startTime));
                this.myListener.onTaskOutput(this.myTaskId, "\rGradle Daemon started in " + duration + "\n", true);
            }
        }
    }
}

