/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.RefreshExternalProjectAction;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRefreshProjectDependenciesAction
extends RefreshExternalProjectAction {
    public GradleRefreshProjectDependenciesAction() {
        this.getTemplatePresentation().setText(GradleBundle.messagePointer("gradle.action.refresh.dependencies.text", new Object[0]));
        this.getTemplatePresentation().setDescription(GradleBundle.messagePointer("gradle.action.refresh.dependencies.description", new Object[0]));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)this.getSystemId(e))) {
            return false;
        }
        return super.isEnabled(e);
    }

    protected boolean isVisible(@NotNull AnActionEvent e) {
        if (!GradleConstants.SYSTEM_ID.equals((Object)this.getSystemId(e))) {
            return false;
        }
        return super.isVisible(e);
    }

    public void perform(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull AbstractExternalEntityData externalEntityData, @NotNull AnActionEvent e) {
        ExternalConfigPathAware externalConfigPathAware;
        List selectedNodes = (List)e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)selectedNodes);
        assert (externalSystemNode != null);
        ExternalConfigPathAware externalConfigPathAware2 = externalConfigPathAware = externalSystemNode.getData() instanceof ExternalConfigPathAware ? (ExternalConfigPathAware)externalSystemNode.getData() : null;
        assert (externalConfigPathAware != null);
        FileDocumentManager.getInstance().saveAllDocuments();
        ExternalProjectSettings linkedProjectSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(externalConfigPathAware.getLinkedExternalProjectPath());
        String externalProjectPath = linkedProjectSettings == null ? externalConfigPathAware.getLinkedExternalProjectPath() : linkedProjectSettings.getExternalProjectPath();
        ExternalSystemUtil.refreshProject((String)externalProjectPath, (ImportSpecBuilder)new ImportSpecBuilder(project, projectSystemId).withArguments("--refresh-dependencies"));
    }
}

