/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.CachingExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import icons.GradleIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradleAutoImportAware;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.settings.GradleConfigurable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public final class GradleManager
implements ExternalSystemConfigurableAware,
ExternalSystemUiAware,
ExternalSystemAutoImportAware,
StartupActivity,
ExternalSystemManager<GradleProjectSettings, GradleSettingsListener, GradleSettings, GradleLocalSettings, GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleManager.class);
    @NotNull
    private final ExternalSystemAutoImportAware myAutoImportDelegate = new CachingExternalSystemAutoImportAware((ExternalSystemAutoImportAware)new GradleAutoImportAware());

    @NotNull
    public ProjectSystemId getSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    @NotNull
    public Function<Project, GradleSettings> getSettingsProvider() {
        return project -> GradleSettings.getInstance(project);
    }

    @NotNull
    public Function<Project, GradleLocalSettings> getLocalSettingsProvider() {
        return project -> GradleLocalSettings.getInstance(project);
    }

    @NotNull
    public Function<Pair<Project, String>, GradleExecutionSettings> getExecutionSettingsProvider() {
        return pair -> {
            GradleProjectSettings projectLevelSettings;
            Project project = (Project)pair.first;
            String projectPath = (String)pair.second;
            GradleSettings settings2 = GradleSettings.getInstance(project);
            GradleInstallationManager gradleInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
            File gradleHome = gradleInstallationManager.getGradleHome(project, projectPath);
            String localGradlePath = null;
            if (gradleHome != null) {
                try {
                    localGradlePath = gradleHome.getCanonicalPath();
                }
                catch (IOException e) {
                    localGradlePath = gradleHome.getAbsolutePath();
                }
            }
            DistributionType distributionType = (projectLevelSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(projectPath)) == null ? (GradleUtil.isGradleDefaultWrapperFilesExist(projectPath) ? DistributionType.DEFAULT_WRAPPED : DistributionType.BUNDLED) : (projectLevelSettings.getDistributionType() == null ? DistributionType.LOCAL : projectLevelSettings.getDistributionType());
            GradleExecutionSettings result = new GradleExecutionSettings(localGradlePath, settings2.getServiceDirectoryPath(), distributionType, settings2.getGradleVmOptions(), settings2.isOfflineWork());
            String rootProjectPath = projectLevelSettings != null ? projectLevelSettings.getExternalProjectPath() : projectPath;
            String javaHome = gradleInstallationManager.getGradleJvmPath(project, rootProjectPath);
            if (!StringUtil.isEmpty((String)javaHome)) {
                LOG.info("Instructing gradle to use java from " + javaHome);
            }
            result.setJavaHome(javaHome);
            String ideProjectPath = project.getBasePath() == null || project.getProjectFilePath() != null && StringUtil.endsWith((CharSequence)project.getProjectFilePath(), (CharSequence)".ipr") ? rootProjectPath : project.getBasePath() + "/.idea/modules";
            result.setIdeProjectPath(ideProjectPath);
            if (projectLevelSettings != null) {
                result.setResolveModulePerSourceSet(projectLevelSettings.isResolveModulePerSourceSet());
                result.setUseQualifiedModuleNames(projectLevelSettings.isUseQualifiedModuleNames());
            }
            boolean delegatedBuildEnabled = GradleProjectSettings.isDelegatedBuildEnabled(project, projectPath);
            result.setDelegatedBuild(delegatedBuildEnabled);
            GradleManager.configureExecutionWorkspace(projectLevelSettings, settings2, result, project, projectPath);
            return result;
        };
    }

    private static void configureExecutionWorkspace(@Nullable GradleProjectSettings compositeRootSettings, GradleSettings settings2, GradleExecutionSettings result, Project project, String projectPath) {
        if (compositeRootSettings == null || compositeRootSettings.getCompositeBuild() == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = compositeRootSettings.getCompositeBuild();
        if (compositeBuild.getCompositeDefinitionSource() == CompositeDefinitionSource.SCRIPT) {
            if (FileUtil.pathsEqual((String)compositeRootSettings.getExternalProjectPath(), (String)projectPath)) {
                return;
            }
            for (BuildParticipant buildParticipant : compositeBuild.getCompositeParticipants()) {
                if (FileUtil.pathsEqual((String)buildParticipant.getRootPath(), (String)projectPath) || buildParticipant.getProjects().stream().anyMatch(path -> FileUtil.pathsEqual((String)path, (String)projectPath))) continue;
                result.getExecutionWorkspace().addBuildParticipant(new GradleBuildParticipant(buildParticipant.getRootPath()));
            }
            return;
        }
        for (GradleProjectSettings projectSettings : settings2.getLinkedProjectsSettings()) {
            if (projectSettings == compositeRootSettings || compositeBuild.getCompositeParticipants().stream().noneMatch(participant -> FileUtil.pathsEqual((String)participant.getRootPath(), (String)projectSettings.getExternalProjectPath()))) continue;
            GradleBuildParticipant buildParticipant = new GradleBuildParticipant(projectSettings.getExternalProjectPath());
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, projectSettings.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) continue;
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                ModuleData moduleData = (ModuleData)moduleNode.getData();
                if (moduleData.getArtifacts().isEmpty()) {
                    Collection sourceSetNodes = ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY);
                    for (DataNode sourceSetNode : sourceSetNodes) {
                        buildParticipant.addModule((ModuleData)sourceSetNode.getData());
                    }
                    continue;
                }
                buildParticipant.addModule(moduleData);
            }
            result.getExecutionWorkspace().addBuildParticipant(buildParticipant);
        }
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Class<? extends ExternalSystemProjectResolver<GradleExecutionSettings>> getProjectResolverClass() {
        return GradleProjectResolver.class;
    }

    public Class<? extends ExternalSystemTaskManager<GradleExecutionSettings>> getTaskManagerClass() {
        return GradleTaskManager.class;
    }

    @NotNull
    public Configurable getConfigurable(@NotNull Project project) {
        return new GradleConfigurable(project);
    }

    @Nullable
    public FileChooserDescriptor getExternalProjectConfigDescriptor() {
        return FileChooserDescriptorFactory.createSingleFolderDescriptor();
    }

    @Nullable
    public Icon getProjectIcon() {
        return GradleIcons.GradleFile;
    }

    @Nullable
    public Icon getTaskIcon() {
        return DefaultExternalSystemUiAware.INSTANCE.getTaskIcon();
    }

    @NotNull
    public String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        return ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
    }

    @NotNull
    public String getProjectRepresentationName(@NotNull Project project, @NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(targetProjectPath);
        if (projectSettings != null && projectSettings.getCompositeBuild() != null) {
            for (BuildParticipant buildParticipant : projectSettings.getCompositeBuild().getCompositeParticipants()) {
                if (!buildParticipant.getProjects().contains(targetProjectPath)) continue;
                return ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)buildParticipant.getRootPath());
            }
        }
        return ExternalSystemApiUtil.getProjectRepresentationName((String)targetProjectPath, (String)rootProjectPath);
    }

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
        return this.myAutoImportDelegate.getAffectedExternalProjectPath(changedFileOrDirPath, project);
    }

    public List<File> getAffectedExternalProjectFiles(String projectPath, @NotNull Project project) {
        return this.myAutoImportDelegate.getAffectedExternalProjectFiles(projectPath, project);
    }

    public boolean isApplicable(@Nullable ProjectResolverPolicy resolverPolicy) {
        return this.myAutoImportDelegate.isApplicable(resolverPolicy);
    }

    @NotNull
    public FileChooserDescriptor getExternalProjectDescriptor() {
        return GradleUtil.getGradleProjectFileChooserDescriptor();
    }

    @Nullable
    public GlobalSearchScope getSearchScope(@NotNull Project project, @NotNull ExternalSystemTaskExecutionSettings taskExecutionSettings) {
        String projectPath = taskExecutionSettings.getExternalProjectPath();
        if (StringUtil.isEmpty((String)projectPath)) {
            return null;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)((GradleSettings)((Object)this.getSettingsProvider().fun((Object)project))).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return null;
        }
        if (!projectSettings.isResolveModulePerSourceSet()) {
            return null;
        }
        List modules = JBIterable.of((Object[])ModuleManager.getInstance((Project)project).getModules()).filter(module -> StringUtil.equals((CharSequence)projectPath, (CharSequence)ExternalSystemApiUtil.getExternalProjectPath((Module)module))).toList();
        return modules.isEmpty() ? null : GlobalSearchScopes.executionScope((Collection)modules);
    }

    public void runActivity(final @NotNull Project project) {
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(GradleSettings.getInstance(project).getChangesTopic(), (Object)new GradleSettingsListenerAdapter(){

            @Override
            public void onServiceDirectoryPathChange(@Nullable String oldPath, @Nullable String newPath) {
                for (GradleProjectSettings projectSettings : GradleSettings.getInstance(project).getLinkedProjectsSettings()) {
                    ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(projectSettings.getExternalProjectPath());
                }
            }

            @Override
            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(linkedProjectPath);
            }

            @Override
            public void onGradleDistributionTypeChange(DistributionType currentValue, @NotNull String linkedProjectPath) {
                ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(linkedProjectPath);
            }

            @Override
            public void onBuildDelegationChange(boolean delegatedBuild, @NotNull String linkedProjectPath) {
                if (!this.updateOutputRoots(delegatedBuild, linkedProjectPath)) {
                    ExternalProjectsManager.getInstance((Project)project).getExternalProjectsWatcher().markDirty(linkedProjectPath);
                }
            }

            private boolean updateOutputRoots(final boolean delegatedBuild, @NotNull String linkedProjectPath) {
                ExternalProjectInfo projectInfo = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, linkedProjectPath);
                if (projectInfo == null) {
                    return false;
                }
                String buildNumber = projectInfo.getBuildNumber();
                if (buildNumber == null) {
                    return false;
                }
                final DataNode projectStructure = projectInfo.getExternalProjectStructure();
                if (projectStructure == null) {
                    return false;
                }
                final String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{((ProjectData)projectStructure.getData()).getExternalName(), projectInfo.getProjectSystemId().getReadableName()});
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        DumbService.getInstance((Project)project).suspendIndexingAndRun(title, () -> {
                            for (DataNode moduleDataNode : ExternalSystemApiUtil.findAll((DataNode)projectStructure, (Key)ProjectKeys.MODULE)) {
                                ((ModuleData)moduleDataNode.getData()).useExternalCompilerOutput(delegatedBuild);
                                for (DataNode sourceSetDataNode : ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY)) {
                                    ((GradleSourceSetData)((Object)((Object)sourceSetDataNode.getData()))).useExternalCompilerOutput(delegatedBuild);
                                }
                            }
                            ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(projectStructure, project, true);
                        });
                    }
                });
                return true;
            }
        });
        Map<String, String> adjustedPaths = GradleManager.patchLinkedProjects(project);
        if (adjustedPaths == null) {
            return;
        }
        GradleLocalSettings localSettings = GradleLocalSettings.getInstance(project);
        GradleManager.patchRecentTasks(adjustedPaths, localSettings);
        GradleManager.patchAvailableProjects(adjustedPaths, localSettings);
    }

    @Nullable
    private static Map<String, String> patchLinkedProjects(@NotNull Project project) {
        GradleSettings settings2 = GradleSettings.getInstance(project);
        ArrayList<GradleProjectSettings> correctedSettings = new ArrayList<GradleProjectSettings>();
        HashMap<String, String> adjustedPaths = new HashMap<String, String>();
        for (GradleProjectSettings projectSettings : settings2.getLinkedProjectsSettings()) {
            String oldPath = projectSettings.getExternalProjectPath();
            if (oldPath != null && new File(oldPath).isFile() && FileUtilRt.extensionEquals((String)oldPath, (String)"gradle")) {
                try {
                    String newPath = new File(oldPath).getParentFile().getCanonicalPath();
                    projectSettings.setExternalProjectPath(newPath);
                    adjustedPaths.put(oldPath, newPath);
                }
                catch (IOException e) {
                    LOG.warn(String.format("Unexpected exception occurred on attempt to re-point linked gradle project path from build.gradle to its parent dir. Path: %s", oldPath), (Throwable)e);
                }
            }
            correctedSettings.add(projectSettings);
        }
        if (adjustedPaths.isEmpty()) {
            return null;
        }
        settings2.setLinkedProjectsSettings(correctedSettings);
        return adjustedPaths;
    }

    private static void patchAvailableProjects(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        HashMap adjustedAvailableProjects = new HashMap();
        for (Map.Entry entry : localSettings.getAvailableProjects().entrySet()) {
            String newPath = adjustedPaths.get(((ExternalProjectPojo)entry.getKey()).getPath());
            if (newPath == null) {
                adjustedAvailableProjects.put(entry.getKey(), entry.getValue());
                continue;
            }
            adjustedAvailableProjects.put(new ExternalProjectPojo(((ExternalProjectPojo)entry.getKey()).getName(), newPath), entry.getValue());
        }
        localSettings.setAvailableProjects(adjustedAvailableProjects);
    }

    private static void patchRecentTasks(@NotNull Map<String, String> adjustedPaths, @NotNull GradleLocalSettings localSettings) {
        for (ExternalTaskExecutionInfo taskInfo : localSettings.getRecentTasks()) {
            ExternalSystemTaskExecutionSettings s = taskInfo.getSettings();
            String newPath = adjustedPaths.get(s.getExternalProjectPath());
            if (newPath == null) continue;
            s.setExternalProjectPath(newPath);
        }
    }
}

