/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction;

import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0081\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/filePrediction/FileNavigationLogger;", "", "()V", "GROUP_ID", "", "logEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "", "features", "", "Lcom/intellij/filePrediction/features/FilePredictionFeature;", "filePath", "prevFilePath", "source", "opened", "", "totalDuration", "", "featuresComputation", "refsComputation", "predictionDuration", "probability", "", "(Lcom/intellij/openapi/project/Project;ILjava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZJJJLjava/lang/Long;Ljava/lang/Double;)V", "roundProbability", "value", "intellij.filePrediction"})
public final class FileNavigationLogger {
    private static final String GROUP_ID = "file.prediction";
    public static final FileNavigationLogger INSTANCE;

    public final void logEvent(@NotNull Project project, int sessionId, @NotNull Map<String, ? extends FilePredictionFeature> features, @NotNull String filePath, @Nullable String prevFilePath, @NotNull String source, boolean opened, long totalDuration, long featuresComputation, long refsComputation, @Nullable Long predictionDuration, @Nullable Double probability) {
        FeatureUsageData data = new FeatureUsageData().addData("session_id", sessionId).addAnonymizedPath(filePath).addAnonymizedValue("prev_file_path", prevFilePath).addData("source", source).addData("opened", opened).addData("total_ms", totalDuration).addData("refs_ms", refsComputation).addData("features_ms", featuresComputation);
        if (predictionDuration != null) {
            data.addData("predict_ms", predictionDuration.longValue());
        }
        if (probability != null) {
            data.addData("probability", this.roundProbability(probability));
        }
        Map<String, ? extends FilePredictionFeature> map = features;
        boolean bl = false;
        for (Map.Entry<String, ? extends FilePredictionFeature> feature : map.entrySet()) {
            feature.getValue().addToEventData(feature.getKey(), data);
        }
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP_ID, "candidate.calculated", data);
    }

    public static /* synthetic */ void logEvent$default(FileNavigationLogger fileNavigationLogger, Project project, int n, Map map, String string, String string2, String string3, boolean bl, long l, long l2, long l3, Long l4, Double d, int n2, Object object) {
        if ((n2 & 0x400) != 0) {
            l4 = null;
        }
        if ((n2 & 0x800) != 0) {
            d = null;
        }
        fileNavigationLogger.logEvent(project, n, map, string, string2, string3, bl, l, l2, l3, l4, d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final double roundProbability(double value) {
        double d = value;
        boolean bl = false;
        double d2 = d;
        boolean bl2 = false;
        if (Double.isInfinite(d2)) return -1.0;
        d2 = d;
        bl2 = false;
        if (Double.isNaN(d2)) return -1.0;
        boolean bl3 = true;
        if (!bl3) {
            return -1.0;
        }
        d = value * (double)100000;
        return Math.rint(d) / (double)100000;
    }

    private FileNavigationLogger() {
    }

    static {
        FileNavigationLogger fileNavigationLogger;
        INSTANCE = fileNavigationLogger = new FileNavigationLogger();
    }
}

