/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.jetbrains.annotations.NotNull;

public abstract class RncElementImpl
extends ASTWrapperPsiElement
implements RncElement,
CommonElement<RncElement> {
    private static final TokenSet GRAMMAR_CONTENT = TokenSet.create((IElementType[])new IElementType[]{RncElementTypes.START, RncElementTypes.DEFINE, RncElementTypes.DIV, RncElementTypes.GRAMMAR_PATTERN, RncElementTypes.PATTERN, RncElementTypes.INCLUDE});

    public RncElementImpl(ASTNode node) {
        super(node);
    }

    public String toString() {
        return this.getNode().getElementType().toString();
    }

    public void delete() throws IncorrectOperationException {
        this.getNode().getTreeParent().removeChild(this.getNode());
    }

    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        ASTNode astNode = psiElement.getNode();
        assert (astNode != null);
        this.getNode().addChild(astNode);
        PsiElement r = this.getNode().getLastChildNode().getPsi();
        assert (r.getClass() == psiElement.getClass());
        return r;
    }

    public PsiElement addBefore(@NotNull PsiElement psiElement, PsiElement anchor) throws IncorrectOperationException {
        ASTNode child = psiElement.getNode();
        assert (child != null);
        ASTNode anchorNode = anchor.getNode();
        assert (anchorNode != null);
        this.getNode().addChild(child, anchorNode);
        PsiElement r = anchorNode.getTreePrev().getPsi();
        assert (r.getClass() == psiElement.getClass());
        return r;
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        ASTNode astNode = anchor.getNode();
        assert (astNode != null);
        ASTNode node = astNode.getTreeNext();
        if (node == null) {
            return this.add(element);
        }
        return this.addBefore(element, node.getPsi());
    }

    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof RncElementVisitor) {
            this.accept((RncElementVisitor)visitor);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        ASTNode astNode = this.getNode();
        ASTNode[] children = astNode.getChildren(GRAMMAR_CONTENT);
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        for (ASTNode element : children) {
            if (processor.execute(element.getPsi(), substitutor)) continue;
            return false;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, null);
        return true;
    }

    public abstract void accept(@NotNull RncElementVisitor var1);

    @Override
    public void accept(CommonElement.Visitor visitor) {
        visitor.visitElement(this);
    }

    @Override
    public void acceptChildren(CommonElement.Visitor visitor) {
        PsiElement[] elements = this.getChildren();
        for (int i = 0; i < elements.length; ++i) {
            PsiElement element = elements[i];
            if (!(element instanceof CommonElement)) continue;
            ((CommonElement)element).accept(visitor);
        }
    }

    @Override
    public RncElement getPsiElement() {
        return this;
    }
}

