/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdReferenceProvider;
import com.intellij.psi.impl.source.xml.PossiblePrefixReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlRefCountHolder {
    private static final Key<CachedValue<XmlRefCountHolder>> xmlRefCountHolderKey = Key.create((String)"xml ref count holder");
    private static final UserDataCache<CachedValue<XmlRefCountHolder>, XmlFile, Object> CACHE = new UserDataCache<CachedValue<XmlRefCountHolder>, XmlFile, Object>(){

        protected CachedValue<XmlRefCountHolder> compute(XmlFile file, Object p) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                XmlRefCountHolder holder = new XmlRefCountHolder();
                Language language = file.getViewProvider().getBaseLanguage();
                PsiFile psiFile = file.getViewProvider().getPsi(language);
                assert (psiFile != null);
                psiFile.accept((PsiElementVisitor)new IdGatheringRecursiveVisitor(holder));
                return new CachedValueProvider.Result((Object)holder, new Object[]{file});
            }, false);
        }
    };
    private final Map<String, List<Pair<XmlAttributeValue, Boolean>>> myId2AttributeListMap = new HashMap<String, List<Pair<XmlAttributeValue, Boolean>>>();
    private final Set<XmlAttributeValue> myPossiblyDuplicateIds = new HashSet<XmlAttributeValue>();
    private final List<XmlAttributeValue> myIdReferences = new ArrayList<XmlAttributeValue>();
    private final Set<String> myAdditionallyDeclaredIds = new HashSet<String>();
    private final Set<PsiElement> myDoNotValidateParentsList = new HashSet<PsiElement>();
    private final Set<String> myUsedPrefixes = new HashSet<String>();
    private final Set<String> myUsedNamespaces = new HashSet<String>();
    private static final Pattern PREFIX_PATTERN = Pattern.compile("[\\w_][\\w_.]*:");

    @Nullable
    public static XmlRefCountHolder getRefCountHolder(@NotNull XmlFile file) {
        return (XmlRefCountHolder)((CachedValue)CACHE.get(xmlRefCountHolderKey, (UserDataHolder)file, null)).getValue();
    }

    private XmlRefCountHolder() {
    }

    public boolean isDuplicateIdAttributeValue(@NotNull XmlAttributeValue value) {
        return this.myPossiblyDuplicateIds.contains(value);
    }

    public boolean isValidatable(@Nullable PsiElement element) {
        return !this.myDoNotValidateParentsList.contains(element);
    }

    public boolean hasIdDeclaration(@NotNull String idRef) {
        return this.myId2AttributeListMap.get(idRef) != null || this.myAdditionallyDeclaredIds.contains(idRef);
    }

    public boolean isIdReferenceValue(@NotNull XmlAttributeValue value) {
        return this.myIdReferences.contains(value);
    }

    private void registerId(@NotNull String id, @NotNull XmlAttributeValue attributeValue, boolean soft) {
        List<Pair<XmlAttributeValue, Boolean>> list = this.myId2AttributeListMap.get(id);
        if (list == null) {
            list = new ArrayList<Pair<XmlAttributeValue, Boolean>>();
            this.myId2AttributeListMap.put(id, list);
        } else if (!soft) {
            boolean html = HtmlUtil.isHtmlFile((PsiElement)attributeValue);
            boolean html5 = HtmlUtil.isHtml5Context((XmlElement)attributeValue);
            List notSoft = ContainerUtil.mapNotNull(list, (Function)((NullableFunction)pair -> {
                if (html5 && !"id".equalsIgnoreCase(((XmlAttribute)((XmlAttributeValue)pair.first).getParent()).getName())) {
                    return null;
                }
                if (html && ((XmlAttributeValue)pair.first).getParent().getParent() == attributeValue.getParent().getParent()) {
                    return null;
                }
                return (Boolean)pair.second != false ? null : (XmlAttributeValue)pair.first;
            }));
            if (!notSoft.isEmpty()) {
                this.myPossiblyDuplicateIds.addAll(notSoft);
                this.myPossiblyDuplicateIds.add(attributeValue);
            }
        }
        list.add((Pair<XmlAttributeValue, Boolean>)new Pair((Object)attributeValue, (Object)soft));
    }

    private void registerAdditionalId(@NotNull String id) {
        this.myAdditionallyDeclaredIds.add(id);
    }

    private void registerIdReference(@NotNull XmlAttributeValue value) {
        this.myIdReferences.add(value);
    }

    private void registerOuterLanguageElement(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof XmlText) {
            parent = parent.getParent();
        }
        this.myDoNotValidateParentsList.add(parent);
    }

    public boolean isInUse(String prefix) {
        return this.myUsedPrefixes.contains(prefix);
    }

    public boolean isUsedNamespace(String ns) {
        return this.myUsedNamespaces.contains(ns);
    }

    private void addUsedPrefix(String prefix) {
        this.myUsedPrefixes.add(prefix);
    }

    private void addUsedNamespace(String ns) {
        this.myUsedNamespaces.add(ns);
    }

    private static class IdGatheringRecursiveVisitor
    extends XmlRecursiveElementWalkingVisitor {
        private final XmlRefCountHolder myHolder;

        private IdGatheringRecursiveVisitor(@NotNull XmlRefCountHolder holder) {
            super(true);
            this.myHolder = holder;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element instanceof OuterLanguageElement) {
                this.visitOuterLanguageElement(element);
            }
            super.visitElement(element);
        }

        private void visitOuterLanguageElement(@NotNull PsiElement element) {
            PsiReference[] references;
            this.myHolder.registerOuterLanguageElement(element);
            for (PsiReference reference : references = element.getReferences()) {
                PsiElement resolve;
                if (!(reference instanceof PossiblePrefixReference) || !((PossiblePrefixReference)reference).isPrefixReference() || !((resolve = reference.resolve()) instanceof SchemaPrefix)) continue;
                this.myHolder.addUsedPrefix(((SchemaPrefix)resolve).getName());
            }
        }

        public void visitComment(@NotNull PsiComment comment) {
            this.doVisitAnyComment(comment);
            super.visitComment(comment);
        }

        public void visitXmlComment(XmlComment comment) {
            this.doVisitAnyComment((PsiComment)comment);
            super.visitXmlComment(comment);
        }

        private void doVisitAnyComment(PsiComment comment) {
            String id = XmlDeclareIdInCommentAction.getImplicitlyDeclaredId(comment);
            if (id != null) {
                this.myHolder.registerAdditionalId(id);
            }
        }

        public void visitXmlTag(XmlTag tag) {
            this.myHolder.addUsedPrefix(tag.getNamespacePrefix());
            this.myHolder.addUsedNamespace(tag.getNamespace());
            String text = tag.getValue().getTrimmedText();
            this.detectPrefix(text, tag);
            super.visitXmlTag(tag);
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            if (!attribute.isNamespaceDeclaration()) {
                this.myHolder.addUsedPrefix(attribute.getNamespacePrefix());
            }
            this.myHolder.addUsedNamespace(attribute.getNamespace());
            super.visitXmlAttribute(attribute);
        }

        public void visitXmlAttributeValue(XmlAttributeValue value) {
            PsiElement element = value.getParent();
            if (!(element instanceof XmlAttribute)) {
                return;
            }
            XmlAttribute attribute = (XmlAttribute)element;
            XmlTag tag = attribute.getParent();
            if (tag == null) {
                return;
            }
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor == null) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
            if (attributeDescriptor != null) {
                if (attributeDescriptor.hasIdType()) {
                    this.updateMap(attribute, value, false);
                } else {
                    PsiReference[] references;
                    for (PsiReference r : references = value.getReferences()) {
                        SchemaPrefix prefix;
                        if (r instanceof IdReferenceProvider.GlobalAttributeValueSelfReference) {
                            this.updateMap(attribute, value, r.isSoft());
                            continue;
                        }
                        if (!(r instanceof SchemaPrefixReference) || (prefix = ((SchemaPrefixReference)r).resolve()) == null) continue;
                        this.myHolder.addUsedPrefix(prefix.getName());
                    }
                }
                if (attributeDescriptor.hasIdRefType() && PsiTreeUtil.getChildOfType((PsiElement)value, OuterLanguageElement.class) == null) {
                    this.myHolder.registerIdReference(value);
                }
            }
            String s = value.getValue();
            this.detectPrefix(s, tag);
            super.visitXmlAttributeValue(value);
        }

        private void detectPrefix(String s, XmlTag tag) {
            if (s != null && !(tag instanceof HtmlTag) && s.length() < 1000) {
                Matcher matcher = PREFIX_PATTERN.matcher(s);
                while (matcher.find()) {
                    String group = matcher.group();
                    this.myHolder.addUsedPrefix(group.substring(0, group.length() - 1));
                }
            }
        }

        private void updateMap(@NotNull XmlAttribute attribute, @NotNull XmlAttributeValue value, boolean soft) {
            String id = XmlHighlightVisitor.getUnquotedValue(value, attribute.getParent());
            if (XmlUtil.isSimpleValue(id, (PsiElement)value) && PsiTreeUtil.getChildOfType((PsiElement)value, OuterLanguageElement.class) == null) {
                this.myHolder.registerId(id, value, soft);
            }
        }
    }
}

