/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;

public class XIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        return "XInclude";
    }

    public boolean acceptFile(@NotNull VirtualFile file) {
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
        fileTypeSink.consume((Object)XmlFileType.INSTANCE);
    }

    public FileIncludeInfo @NotNull [] getIncludeInfos(@NotNull FileContent content) {
        CharSequence contentAsText = content.getContentAsText();
        if (CharArrayUtil.indexOf((CharSequence)contentAsText, (CharSequence)"http://www.w3.org/2001/XInclude", (int)0) == -1) {
            return FileIncludeInfo.EMPTY;
        }
        final ArrayList infos = new ArrayList();
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)contentAsText), (IXMLBuilder)new NanoXmlBuilder(){
            boolean isXInclude;

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
                this.isXInclude = "http://www.w3.org/2001/XInclude".equals(nsURI) && "include".equals(name);
            }

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
                if (this.isXInclude && "href".equals(key)) {
                    infos.add(new FileIncludeInfo(value));
                }
            }

            public void endElement(String name, String nsPrefix, String nsURI) {
                this.isXInclude = false;
            }
        });
        return infos.toArray(FileIncludeInfo.EMPTY);
    }
}

