/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.lookup.DeferredUserLookupValue;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithPriority;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.ColorIconCache;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSampleLookupValue
implements LookupValueWithUIHint,
DeferredUserLookupValue,
Iconable,
LookupValueWithPriority {
    private static volatile ColorSampleLookupValue[] ourColors;
    private final boolean myIsStandard;
    private final String myName;
    private final String myValue;
    private Color myColor;
    @NonNls
    private static final String BR = "<br>";

    public ColorSampleLookupValue(String name, String value, boolean isStandard) {
        this.myName = name;
        this.myValue = value;
        this.myIsStandard = isStandard;
    }

    public String getPresentation() {
        return this.myName != null ? this.myName : this.myValue;
    }

    public String getValue() {
        return this.myValue;
    }

    public boolean isIsStandard() {
        return this.myIsStandard;
    }

    public Icon getIcon(int flags) {
        if (this.myColor == null && this.myValue.startsWith("#")) {
            try {
                this.myColor = Color.decode("0x" + this.myValue.substring(1));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.myColor != null) {
            return ColorIconCache.getIconCache().getIcon(this.myColor, 32);
        }
        return null;
    }

    public boolean handleUserSelection(LookupItem item, Project project) {
        if (!this.myIsStandard) {
            item.setLookupString(this.myValue);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColorSampleLookupValue @NotNull [] getColors() {
        if (ourColors != null) return ourColors;
        Class<ColorSampleLookupValue> clazz = ColorSampleLookupValue.class;
        synchronized (ColorSampleLookupValue.class) {
            String name;
            if (ourColors != null) return ourColors;
            LinkedList<ColorSampleLookupValue> colorsList = new LinkedList<ColorSampleLookupValue>();
            StringTokenizer tokenizer = new StringTokenizer("ActiveBorder\n    Active window border.\nActiveCaption\n    Active window caption.\nAppWorkspace\n    Background color of multiple document interface.\nBackground\n    Desktop background.\nButtonFace\n    Face color for three-dimensional display elements.\nButtonHighlight\n    Highlight color for three-dimensional display elements (for edges facing away from the light source).\nButtonShadow\n    Shadow color for three-dimensional display elements.\nButtonText\n    Text on push buttons.\nCaptionText\n    Text in caption, size box, and scrollbar arrow box.\nGrayText\n    Grayed (disabled) text. This color is set to #000 if the current display driver does not support a solid gray color.\nHighlight\n    Item(s) selected in a control.\nHighlightText\n    Text of item(s) selected in a control.\nInactiveBorder\n    Inactive window border.\nInactiveCaption\n    Inactive window caption.\nInactiveCaptionText\n    Color of text in an inactive caption.\nInfoBackground\n    Background color for tooltip controls.\nInfoText\n    Text color for tooltip controls.\nMenu\n    Menu background.\nMenuText\n    Text in menus.\nScrollbar\n    Scroll bar gray area.\nThreeDDarkShadow\n    Dark shadow for three-dimensional display elements.\nThreeDFace\n    Face color for three-dimensional display elements.\nThreeDHighlight\n    Highlight color for three-dimensional display elements.\nThreeDLightShadow\n    Light color for three-dimensional display elements (for edges facing the light source).\nThreeDShadow\n    Dark shadow for three-dimensional display elements.\nWindow\n    Window background.\nWindowFrame\n    Window frame.\nWindowText\n    Text in windows. ", "\n");
            while (tokenizer.hasMoreTokens()) {
                String name2 = tokenizer.nextToken();
                colorsList.add(new ColorSampleLookupValue(name2, name2, false));
                tokenizer.nextToken();
            }
            tokenizer = new StringTokenizer("maroon #800000 red #ff0000 orange #ffA500 yellow #ffff00 olive #808000\npurple #800080 fuchsia #ff00ff white #ffffff lime #00ff00 green #008000\nnavy #000080 blue #0000ff aqua #00ffff teal #008080\nblack #000000 silver #c0c0c0 gray #808080", ", \n");
            HashMap<String, String> standardColors = new HashMap<String, String>();
            while (tokenizer.hasMoreTokens()) {
                name = tokenizer.nextToken();
                String value = tokenizer.nextToken();
                standardColors.put(name, name);
                colorsList.add(new ColorSampleLookupValue(name, value, true));
            }
            tokenizer = new StringTokenizer("aliceblue \t#f0f8ff \t240,248,255\n  \t  \tantiquewhite \t#faebd7 \t250,235,215\n  \t  \taqua \t#00ffff \t0,255,255\n  \t  \taquamarine \t#7fffd4 \t127,255,212\n  \t  \tazure \t#f0ffff \t240,255,255\n  \t  \tbeige \t#f5f5dc \t245,245,220\n  \t  \tbisque \t#ffe4c4 \t255,228,196\n  \t  \tblack \t#000000 \t0,0,0\n  \t  \tblanchedalmond \t#ffebcd \t255,235,205\n  \t  \tblue \t#0000ff \t0,0,255\n  \t  \tblueviolet \t#8a2be2 \t138,43,226\n  \t  \tbrown \t#a52a2a \t165,42,42\n  \t  \tburlywood \t#deb887 \t222,184,135\n  \t  \tcadetblue \t#5f9ea0 \t95,158,160\n  \t  \tchartreuse \t#7fff00 \t127,255,0\n  \t  \tchocolate \t#d2691e \t210,105,30\n  \t  \tcoral \t#ff7f50 \t255,127,80\n  \t  \tcornflowerblue \t#6495ed \t100,149,237\n  \t  \tcornsilk \t#fff8dc \t255,248,220\n  \t  \tcrimson \t#dc143c \t220,20,60\n  \t  \tcyan \t#00ffff \t0,255,255\n  \t  \tdarkblue \t#00008b \t0,0,139\n  \t  \tdarkcyan \t#008b8b \t0,139,139\n  \t  \tdarkgoldenrod \t#b8860b \t184,134,11\n  \t  \tdarkgray \t#a9a9a9 \t169,169,169\n  \t  \tdarkgrey \t#a9a9a9 \t169,169,169\n  \t  \tdarkgreen \t#006400 \t0,100,0\n  \t  \tdarkkhaki \t#bdb76b \t189,183,107\n  \t  \tdarkmagenta \t#8b008b \t139,0,139\n  \t  \tdarkolivegreen \t#556b2f \t85,107,47\n  \t  \tdarkorange \t#ff8c00 \t255,140,0\n  \t  \tdarkorchid \t#9932cc \t153,50,204\n  \t  \tdarkred \t#8b0000 \t139,0,0\n  \t  \tdarksalmon \t#e9967a \t233,150,122\n  \t  \tdarkseagreen \t#8fbc8f \t143,188,143\n  \t  \tdarkslateblue \t#483d8b \t72,61,139\n  \t  \tdarkslategray \t#2f4f4f \t47,79,79\n  \t  \tdarkslategrey \t#2f4f4f \t47,79,79\n  \t  \tdarkturquoise \t#00ced1 \t0,206,209\n  \t  \tdarkviolet \t#9400d3 \t148,0,211\n  \t  \tdeeppink \t#ff1493 \t255,20,147\n  \t  \tdeepskyblue \t#00bfff \t0,191,255\n  \t  \tdimgray \t#696969 \t105,105,105\n  \t  \tdimgrey \t#696969 \t105,105,105\n  \t  \tdodgerblue \t#1e90ff \t30,144,255\n  \t  \tfirebrick \t#b22222 \t178,34,34\n  \t  \tfloralwhite \t#fffaf0 \t255,250,240\n  \t  \tforestgreen \t#228b22 \t34,139,34\n  \t  \tfuchsia \t#ff00ff \t255,0,255\n  \t  \tgainsboro \t#dcdcdc \t220,220,220\n  \t  \tghostwhite \t#f8f8ff \t248,248,255\n  \t  \tgold \t#ffd700 \t255,215,0\n  \t  \tgoldenrod \t#daa520 \t218,165,32\n  \t  \tgray \t#808080 \t128,128,128\n  \t  \tgrey \t#808080 \t128,128,128\n  \t  \tgreen \t#008000 \t0,128,0\n  \t  \tgreenyellow \t#adff2f \t173,255,47\n  \t  \thoneydew \t#f0fff0 \t240,255,240\n  \t  \thotpink \t#ff69b4 \t255,105,180\n  \t  \tindianred \t#cd5c5c \t205,92,92\n  \t  \tindigo \t#4b0082 \t75,0,130\n  \t  \tivory \t#fffff0 \t255,255,240\n  \t  \tkhaki \t#f0e68c \t240,230,140\n  \t  \tlavender \t#e6e6fa \t230,230,250\n  \t  \tlavenderblush \t#fff0f5 \t255,240,245\n  \t  \tlawngreen \t#7cfc00 \t124,252,0\n  \t  \tlemonchiffon \t#fffacd \t255,250,205\n  \t  \tlightblue \t#add8e6 \t173,216,230\n  \t  \tlightcoral \t#f08080 \t240,128,128\n  \t  \tlightcyan \t#e0ffff \t224,255,255\n  \t  \tlightgoldenrodyellow \t#fafad2 \t250,250,210\n  \t  \tlightgray \t#d3d3d3 \t211,211,211\n  \t  \tlightgrey \t#d3d3d3 \t211,211,211\n  \t  \tlightgreen \t#90ee90 \t144,238,144\n  \t  \tlightpink \t#ffb6c1 \t255,182,193\n  \t  \tlightsalmon \t#ffa07a \t255,160,122\n  \t  \tlightseagreen \t#20b2aa \t32,178,170\n  \t  \tlightskyblue \t#87cefa \t135,206,250\n  \t  \tlightslategray \t#778899 \t119,136,153\n  \t  \tlightslategrey \t#778899 \t119,136,153\n  \t  \tlightsteelblue \t#b0c4de \t176,196,222\n  \t  \tlightyellow \t#ffffe0 \t255,255,224\n  \t  \tlime \t#00ff00 \t0,255,0\n  \t  \tlimegreen \t#32cd32 \t50,205,50\n  \t  \tlinen \t#faf0e6 \t250,240,230\n  \t  \tmagenta \t#ff00ff \t255,0,255\n  \t  \tmaroon \t#800000 \t128,0,0\n  \t  \tmediumaquamarine \t#66cdaa \t102,205,170\n  \t  \tmediumblue \t#0000cd \t0,0,205\n  \t  \tmediumorchid \t#ba55d3 \t186,85,211\n  \t  \tmediumpurple \t#9370db \t147,112,219\n  \t  \tmediumseagreen \t#3cb371 \t60,179,113\n  \t  \tmediumslateblue \t#7b68ee \t123,104,238\n  \t  \tmediumspringgreen \t#00fa9a \t0,250,154\n  \t  \tmediumturquoise \t#48d1cc \t72,209,204\n  \t  \tmediumvioletred \t#c71585 \t199,21,133\n  \t  \tmidnightblue \t#191970 \t25,25,112\n  \t  \tmintcream \t#f5fffa \t245,255,250\n  \t  \tmistyrose \t#ffe4e1 \t255,228,225\n  \t  \tmoccasin \t#ffe4b5 \t255,228,181\n  \t  \tnavajowhite \t#ffdead \t255,222,173\n  \t  \tnavy \t#000080 \t0,0,128\n  \t  \toldlace \t#fdf5e6 \t253,245,230\n  \t  \tolive \t#808000 \t128,128,0\n  \t  \tolivedrab \t#6b8e23 \t107,142,35\n  \t  \torange \t#ffa500 \t255,165,0\n  \t  \torangered \t#ff4500 \t255,69,0\n  \t  \torchid \t#da70d6 \t218,112,214\n  \t  \tpalegoldenrod \t#eee8aa \t238,232,170\n  \t  \tpalegreen \t#98fb98 \t152,251,152\n  \t  \tpaleturquoise \t#afeeee \t175,238,238\n  \t  \tpalevioletred \t#db7093 \t219,112,147\n  \t  \tpapayawhip \t#ffefd5 \t255,239,213\n  \t  \tpeachpuff \t#ffdab9 \t255,218,185\n  \t  \tperu \t#cd853f \t205,133,63\n  \t  \tpink \t#ffc0cb \t255,192,203\n  \t  \tplum \t#dda0dd \t221,160,221\n  \t  \tpowderblue \t#b0e0e6 \t176,224,230\n  \t  \tpurple \t#800080 \t128,0,128\n  \t  \tred \t#ff0000 \t255,0,0\n  \t  \trebeccapurple \t#663399 \t102,51,153\n  \t  \trosybrown \t#bc8f8f \t188,143,143\n  \t  \troyalblue \t#4169e1 \t65,105,225\n  \t  \tsaddlebrown \t#8b4513 \t139,69,19\n  \t  \tsalmon \t#fa8072 \t250,128,114\n  \t  \tsandybrown \t#f4a460 \t244,164,96\n  \t  \tseagreen \t#2e8b57 \t46,139,87\n  \t  \tseashell \t#fff5ee \t255,245,238\n  \t  \tsienna \t#a0522d \t160,82,45\n  \t  \tsilver \t#c0c0c0 \t192,192,192\n  \t  \tskyblue \t#87ceeb \t135,206,235\n  \t  \tslateblue \t#6a5acd \t106,90,205\n  \t  \tslategray \t#708090 \t112,128,144\n  \t  \tslategrey \t#708090 \t112,128,144\n  \t  \tsnow \t#fffafa \t255,250,250\n  \t  \tspringgreen \t#00ff7f \t0,255,127\n  \t  \tsteelblue \t#4682b4 \t70,130,180\n  \t  \ttan \t#d2b48c \t210,180,140\n  \t  \tteal \t#008080 \t0,128,128\n  \t  \tthistle \t#d8bfd8 \t216,191,216\n  \t  \ttomato \t#ff6347 \t255,99,71\n  \t  \tturquoise \t#40e0d0 \t64,224,208\n  \t  \tviolet \t#ee82ee \t238,130,238\n  \t  \twheat \t#f5deb3 \t245,222,179\n  \t  \twhite \t#ffffff \t255,255,255\n  \t  \twhitesmoke \t#f5f5f5 \t245,245,245\n  \t  \tyellow \t#ffff00 \t255,255,0\n  \t  \tyellowgreen \t#9acd32 \t154,205,50", " \t\n");
            while (tokenizer.hasMoreTokens()) {
                name = tokenizer.nextToken();
                String hexValue = tokenizer.nextToken();
                tokenizer.nextToken();
                if (standardColors.containsKey(name)) continue;
                colorsList.add(new ColorSampleLookupValue(name, hexValue, false));
            }
            ourColors = colorsList.toArray(new ColorSampleLookupValue[0]);
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourColors;
        }
    }

    @Nullable
    public String getTypeHint() {
        return this.myName != null && !StringUtil.startsWithChar((CharSequence)this.myName, (char)'#') && this.myValue != null && StringUtil.startsWithChar((CharSequence)this.myValue, (char)'#') ? this.myValue : null;
    }

    public String getName() {
        return this.myName;
    }

    public int getPriority() {
        return this.myName == null || Character.isLowerCase(this.myName.charAt(0)) ? 1 : 0;
    }

    private static String toHex(@NotNull Color color) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            String s = Integer.toHexString(i == 0 ? color.getRed() : (i == 1 ? color.getGreen() : color.getBlue()));
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String toString() {
        return this.myName == null ? this.myValue : this.myValue + " " + this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColorSampleLookupValue)) {
            return false;
        }
        ColorSampleLookupValue value = (ColorSampleLookupValue)o;
        if (this.myIsStandard != value.myIsStandard) {
            return false;
        }
        if (this.myColor != null ? !this.myColor.equals(value.myColor) : value.myColor != null) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(value.myName) : value.myName != null) {
            return false;
        }
        return !(this.myValue != null ? !this.myValue.equals(value.myValue) : value.myValue != null);
    }

    public int hashCode() {
        int result = this.myIsStandard ? 1 : 0;
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        result = 31 * result + (this.myValue != null ? this.myValue.hashCode() : 0);
        result = 31 * result + (this.myColor != null ? this.myColor.hashCode() : 0);
        return result;
    }
}

