/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.text.TextRangeUtil;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFormatUtil {
    private static final List<PsiElement> EMPTY_PSI_ELEMENT_LIST = new ArrayList<PsiElement>();
    private static final String[] IGNORABLE_ERROR_MESSAGES = new String[]{XmlPsiBundle.message((String)"xml.parsing.closing.tag.matches.nothing", (Object[])new Object[0]), XmlPsiBundle.message((String)"xml.parsing.closing.tag.name.missing", (Object[])new Object[0])};

    private TemplateFormatUtil() {
    }

    @NotNull
    static List<PsiElement> findAllMarkupLanguageElementsInside(PsiElement outerLangElement) {
        PsiFile file = outerLangElement.getContainingFile();
        if (file != null && file.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)file.getViewProvider();
            return TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, false);
        }
        return EMPTY_PSI_ELEMENT_LIST;
    }

    @NotNull
    static List<PsiElement> findAllTemplateLanguageElementsInside(@NotNull PsiElement outerLangElement, @NotNull TemplateLanguageFileViewProvider viewProvider) {
        return TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, true);
    }

    @NotNull
    static List<PsiElement> findAllElementsInside(@NotNull TextRange range, @NotNull TemplateLanguageFileViewProvider viewProvider, boolean fromTemplate) {
        return TemplateFormatUtil.findAllElementsInside(range, viewProvider, viewProvider.getBaseLanguage(), fromTemplate ? viewProvider.getBaseLanguage() : viewProvider.getTemplateDataLanguage());
    }

    @NotNull
    public static List<PsiElement> findAllElementsInside(TextRange range, TemplateLanguageFileViewProvider viewProvider, Language templateLanguage, Language language) {
        ArrayList<PsiElement> matchingElements = new ArrayList<PsiElement>();
        PsiElement currElement = viewProvider.findElementAt(range.getStartOffset(), language);
        while (currElement instanceof OuterLanguageElement) {
            currElement = currElement.getNextSibling();
        }
        if (currElement != null) {
            currElement = TemplateFormatUtil.findTopmostElementInRange(currElement, range);
            Pair<Integer, PsiElement> result = TemplateFormatUtil.addElementSequence(currElement, templateLanguage, range, matchingElements, templateLanguage == language);
            int lastOffset = (Integer)result.first;
            assert (lastOffset >= 0) : "Failed to process elements in range: " + range;
            if (lastOffset < range.getEndOffset()) {
                List<PsiElement> moreElements = TemplateFormatUtil.findAllElementsInside(new TextRange(lastOffset, range.getEndOffset()), viewProvider, templateLanguage, language);
                matchingElements.addAll(moreElements);
            }
        }
        return matchingElements;
    }

    private static Pair<Integer, PsiElement> addElementSequence(PsiElement startElement, Language templateLanguage, TextRange range, List<? super PsiElement> targetList, boolean fromTemplate) {
        PsiElement child;
        PsiElement currElement;
        int lastOffset = -1;
        for (currElement = startElement; currElement != null && (lastOffset = currElement.getTextRange().getEndOffset()) <= range.getEndOffset(); currElement = currElement.getNextSibling()) {
            boolean isTemplateLanguage = templateLanguage.isKindOf(currElement.getLanguage());
            if (fromTemplate != isTemplateLanguage) continue;
            targetList.add((PsiElement)currElement);
        }
        if (currElement != null && currElement.getTextRange().intersects(range) && (child = currElement.getFirstChild()) != null) {
            TemplateFormatUtil.addElementSequence(child, templateLanguage, range, targetList, fromTemplate);
        }
        return new Pair((Object)lastOffset, (Object)currElement);
    }

    @NotNull
    public static PsiElement findTopmostElementInRange(@NotNull PsiElement original, TextRange fitToRange) {
        PsiElement prevElement = original;
        for (PsiElement currElement = original; currElement != null; currElement = currElement.getParent()) {
            if (currElement instanceof PsiFile || !fitToRange.contains(currElement.getTextRange())) {
                if (!fitToRange.contains(prevElement.getTextRange())) {
                    return original;
                }
                return prevElement;
            }
            prevElement = currElement;
        }
        return original;
    }

    static List<Block> mergeBlocks(List<Block> originalBlocks, List<? extends Block> blocksToMerge, TextRange range) throws FragmentedTemplateException {
        int n;
        int n2;
        if (blocksToMerge.isEmpty()) {
            return originalBlocks;
        }
        ArrayList<Block> result = new ArrayList<Block>();
        if (originalBlocks.isEmpty()) {
            for (Block block : blocksToMerge) {
                if (!range.contains(block.getTextRange())) continue;
                result.add(block);
            }
            return result;
        }
        ArrayList<TextRange> originalRanges = new ArrayList<TextRange>();
        for (Block originalBlock : originalBlocks) {
            originalRanges.add(originalBlock.getTextRange());
        }
        int n3 = range.getStartOffset();
        Iterator<Block> originalBlockIterator = originalBlocks.iterator();
        while (originalBlockIterator.hasNext()) {
            Block mergeableBlock;
            Block originalBlock = originalBlockIterator.next();
            int startOffset = originalBlock.getTextRange().getStartOffset();
            if (n2 < startOffset && (n2 = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result, n2, startOffset)) < startOffset) {
                n2 = TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result, n2, startOffset);
            }
            if ((mergeableBlock = TemplateFormatUtil.getBlockContaining(blocksToMerge, originalRanges, originalBlock.getTextRange())) != null) {
                if (mergeableBlock.getTextRange().getStartOffset() < n2) continue;
                result.add(mergeableBlock);
                n2 = mergeableBlock.getTextRange().getEndOffset();
                continue;
            }
            if (startOffset < n2) continue;
            result.add(originalBlock);
            originalBlockIterator.remove();
            n2 = originalBlock.getTextRange().getEndOffset();
        }
        if (n2 < range.getEndOffset() && (n = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result, n2, range.getEndOffset())) < range.getEndOffset()) {
            TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result, n, range.getEndOffset());
        }
        return result;
    }

    private static int fillGap(List<? extends TextRange> originalRanges, List<? extends Block> blocks, List<? super Block> result, int startOffset, int endOffset) throws FragmentedTemplateException {
        return TemplateFormatUtil.fillGap(null, originalRanges, blocks, result, startOffset, endOffset, 0);
    }

    private static int fillGap(@Nullable Block parent, List<? extends TextRange> originalRanges, List<? extends Block> blocks, List<? super Block> result, int startOffset, int endOffset, int depth) throws FragmentedTemplateException {
        int lastOffset = startOffset;
        TextRange currRange = new TextRange(lastOffset, endOffset);
        for (Block block : blocks) {
            if (lastOffset == endOffset || block.getTextRange().getStartOffset() > endOffset) {
                return lastOffset;
            }
            if (currRange.contains(block.getTextRange())) {
                result.add((Block)block);
                if (parent != null && block instanceof IndentInheritingBlock) {
                    ((IndentInheritingBlock)block).setIndent(parent.getIndent());
                }
                lastOffset = block.getTextRange().getEndOffset();
                currRange = new TextRange(lastOffset, endOffset);
                continue;
            }
            if (!currRange.intersects(block.getTextRange()) || !TextRangeUtil.intersectsOneOf((TextRange)block.getTextRange(), originalRanges)) continue;
            List subBlocks = block.getSubBlocks();
            if (block instanceof TemplateLanguageBlock && ((TemplateLanguageBlock)block).containsErrorElements()) {
                throw new FragmentedTemplateException();
            }
            lastOffset = TemplateFormatUtil.fillGap(block, originalRanges, subBlocks, result, lastOffset, endOffset, depth + 1);
            currRange = new TextRange(lastOffset, endOffset);
        }
        return lastOffset;
    }

    private static Block getBlockContaining(List<? extends Block> blockList, List<? extends TextRange> originalRanges, TextRange range) {
        return TemplateFormatUtil.getBlockContaining(blockList, originalRanges, range, 0);
    }

    @Nullable
    private static Block getBlockContaining(List<? extends Block> blockList, List<? extends TextRange> originalRanges, TextRange range, int depth) {
        for (Block block : blockList) {
            Block containingBlock;
            if (!block.getTextRange().contains(range)) continue;
            if (TextRangeUtil.intersectsOneOf((TextRange)block.getTextRange(), originalRanges) && (containingBlock = TemplateFormatUtil.getBlockContaining(block.getSubBlocks(), originalRanges, range, depth + 1)) != null) {
                return containingBlock;
            }
            return block;
        }
        return null;
    }

    @Nullable
    public static Block buildTemplateLanguageBlock(@NotNull OuterLanguageElement outerElement, @NotNull CodeStyleSettings settings, @Nullable Indent indent) {
        try {
            FormattingModel model;
            Language language;
            FormattingModelBuilder builder;
            PsiFile file = outerElement.getContainingFile();
            FileViewProvider viewProvider = outerElement.getContainingFile().getViewProvider();
            if (viewProvider instanceof TemplateLanguageFileViewProvider && (builder = LanguageFormatting.INSTANCE.forContext(language = outerElement.getLanguage(), (PsiElement)outerElement)) instanceof AbstractXmlTemplateFormattingModelBuilder && (model = ((AbstractXmlTemplateFormattingModelBuilder)builder).createTemplateFormattingModel(file, (TemplateLanguageFileViewProvider)viewProvider, outerElement, settings, indent)) != null) {
                return model.getRootBlock();
            }
        }
        catch (FragmentedTemplateException fragmentedTemplateException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isErrorElement(@NotNull PsiElement element) {
        if (element instanceof PsiErrorElement) {
            String description = ((PsiErrorElement)element).getErrorDescription();
            for (String ignorableMessage : IGNORABLE_ERROR_MESSAGES) {
                if (!ignorableMessage.equals(description)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

