/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.NamedObjectDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XsdEnumerationDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeDescriptorImpl
extends XsdEnumerationDescriptor
implements PsiWritableMetaData,
XmlAttributeDescriptor {
    private XmlTag myTag;
    String myUse;
    String myReferenceName;
    @NonNls
    public static final String REQUIRED_ATTR_VALUE = "required";
    @NonNls
    public static final String QUALIFIED_ATTR_VALUE = "qualified";

    public XmlAttributeDescriptorImpl(XmlTag tag) {
        this.myTag = tag;
        this.myUse = this.myTag.getAttributeValue("use");
    }

    public XmlAttributeDescriptorImpl() {
    }

    @Override
    public XmlTag getDeclaration() {
        return this.myTag;
    }

    public String getName() {
        return this.myTag.getAttributeValue("name");
    }

    public void init(PsiElement element) {
        this.myTag = (XmlTag)element;
        this.myUse = this.myTag.getAttributeValue("use");
    }

    public boolean isRequired() {
        return REQUIRED_ATTR_VALUE.equals(this.myUse);
    }

    private boolean hasSimpleSchemaType(@NonNls String type) {
        String attributeValue = this.getType();
        if (attributeValue != null && attributeValue.endsWith(type)) {
            String namespacePrefix = this.myTag.getNamespacePrefix();
            if (namespacePrefix.length() > 0) {
                return attributeValue.equals(namespacePrefix + ":" + type);
            }
            return attributeValue.equals(type);
        }
        return false;
    }

    @Nullable
    public String getType() {
        return this.myTag.getAttributeValue("type");
    }

    public boolean hasIdType() {
        return this.hasSimpleSchemaType("ID");
    }

    public boolean hasIdRefType() {
        return this.hasSimpleSchemaType("IDREF");
    }

    public boolean isEnumerated() {
        return this.isEnumerated(null);
    }

    @Nullable
    public String validateValue(XmlElement context, String value) {
        return null;
    }

    public String getName(PsiElement context) {
        String prefixByNamespace;
        String name = this.getName();
        if (context == null) {
            return name;
        }
        XmlTag rootTag = ((XmlFile)this.myTag.getContainingFile()).getRootTag();
        assert (rootTag != null);
        String targetNs = rootTag.getAttributeValue("targetNamespace");
        if (targetNs == null) {
            return name;
        }
        XmlTag contextTag = (XmlTag)context;
        if ((QUALIFIED_ATTR_VALUE.equals(this.myTag.getAttributeValue("form")) || QUALIFIED_ATTR_VALUE.equals(rootTag.getAttributeValue("attributeFormDefault")) || this.shouldBeQualified(targetNs, contextTag)) && (prefixByNamespace = contextTag.getPrefixByNamespace(targetNs)) != null && prefixByNamespace.length() > 0) {
            name = prefixByNamespace + ":" + name;
        }
        return name;
    }

    private boolean shouldBeQualified(String targetNs, XmlTag contextTag) {
        XmlElementDescriptor xmlElementDescriptor;
        boolean attributeShouldBeQualified = false;
        String contextNs = contextTag.getNamespace();
        if (!contextNs.equals(targetNs) && (xmlElementDescriptor = contextTag.getDescriptor()) instanceof XmlElementDescriptorImpl) {
            XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)xmlElementDescriptor;
            TypeDescriptor type = elementDescriptor.getType();
            if (type instanceof ComplexTypeDescriptor) {
                ComplexTypeDescriptor typeDescriptor = (ComplexTypeDescriptor)type;
                if (this.myReferenceName != null) {
                    return this.myReferenceName.indexOf(58) != 0;
                }
                Object[] attributes = ((ComplexTypeDescriptor)type).getAttributes((XmlElement)contextTag);
                if (ArrayUtil.contains((Object)this, (Object[])attributes)) {
                    return false;
                }
                boolean bl = attributeShouldBeQualified = typeDescriptor.canContainAttribute(targetNs, null) != ComplexTypeDescriptor.CanContainAttributeType.CanNotContain;
            }
            if (!attributeShouldBeQualified && contextNs.length() == 0 && targetNs.length() > 0) {
                attributeShouldBeQualified = !targetNs.equals(elementDescriptor.getNamespace());
            }
        }
        return attributeShouldBeQualified;
    }

    public void setName(String name) throws IncorrectOperationException {
        NamedObjectDescriptor.setName(this.myTag, name);
    }

    public String toString() {
        return this.getName();
    }

    public Object @NotNull [] getDependencies() {
        return new Object[]{this.getDeclaration()};
    }
}

