/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.impl.schema.SchemaDefinitionsSearch;
import org.jetbrains.annotations.NotNull;

public class GotoXmlSchemaTypeRendererProvider
implements GotoTargetRendererProvider {
    public PsiElementListCellRenderer getRenderer(@NotNull PsiElement element, @NotNull GotoTargetHandler.GotoData gotoData) {
        if (element instanceof XmlTag) {
            if (SchemaDefinitionsSearch.isTypeElement((XmlTag)element)) {
                return new MyRenderer("");
            }
            if (SchemaDefinitionsSearch.isElementWithSomeEmbeddedType((XmlTag)element)) {
                return new MyRenderer("xsd:element: ");
            }
        }
        return null;
    }

    private static class MyRenderer
    extends PsiElementListCellRenderer<XmlTag> {
        private final String myPrefix;

        private MyRenderer(String prefix) {
            this.myPrefix = prefix;
        }

        public String getElementText(XmlTag element) {
            XmlAttribute attr = SchemaDefinitionsSearch.getNameAttr(element);
            return this.myPrefix + (attr == null || attr.getValue() == null ? element.getName() : attr.getValue());
        }

        protected String getContainerText(XmlTag element, String name) {
            PsiFile file = element.getContainingFile();
            return "(" + file.getName() + ")";
        }

        protected int getIconFlags() {
            return 0;
        }
    }
}

