/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dtd;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeDescriptorImpl
extends BasicXmlAttributeDescriptor
implements PsiWritableMetaData {
    private XmlAttributeDecl myDecl;
    private boolean myRequired;
    private boolean myEnumerated;
    private boolean myFixed;
    private String myName;

    public XmlAttributeDescriptorImpl() {
    }

    public XmlAttributeDescriptorImpl(XmlAttributeDecl decl) {
        this.init((PsiElement)decl);
    }

    public boolean isRequired() {
        return this.myRequired;
    }

    public PsiElement getDeclaration() {
        return this.myDecl;
    }

    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        this.myName = this.myDecl.getNameElement().getText();
        return this.myName;
    }

    public void init(PsiElement element) {
        this.myDecl = (XmlAttributeDecl)element;
        this.myRequired = this.myDecl.isAttributeRequired();
        this.myFixed = this.myDecl.isAttributeFixed();
        this.myEnumerated = this.myDecl.isEnumerated();
    }

    public Object @NotNull [] getDependencies() {
        return new Object[]{this.myDecl};
    }

    @Override
    public boolean isFixed() {
        return this.myFixed;
    }

    public boolean hasIdType() {
        return this.myDecl.isIdAttribute();
    }

    public boolean hasIdRefType() {
        return this.myDecl.isIdRefAttribute();
    }

    @Override
    public String getDefaultValue() {
        String text = this.myDecl.getDefaultValueText();
        if (text != null) {
            return text.substring(1, text.length() - 1);
        }
        return null;
    }

    public boolean isEnumerated() {
        return this.myEnumerated;
    }

    @Override
    public String[] getEnumeratedValues() {
        XmlElement[] values = this.myDecl.getEnumeratedValues();
        ArrayList<String> result = new ArrayList<String>();
        for (XmlElement value : values) {
            result.add(value.getText());
        }
        return ArrayUtilRt.toStringArray(result);
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public void setName(String name) throws IncorrectOperationException {
        this.myName = name;
        ((PsiNamedElement)this.getDeclaration()).setName(name);
    }
}

