/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.xml.XmlNamedReferenceHost;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.xml.XmlNamedReferenceProviderBean;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@ApiStatus.Internal
public final class NamedReferenceProviders {
    private static final ExtensionPointName<XmlNamedReferenceProviderBean> EP_NAME = ExtensionPointName.create((String)"com.intellij.xml.namedReferenceProvider");
    private final Map<Class<?>, ByHostClass> myByHostClass = new ConcurrentHashMap(2);
    private final Map<Class<?>, Collection<PsiSymbolReferenceProvider>> myByTargetClass = new ConcurrentHashMap();

    @NotNull
    static NamedReferenceProviders getInstance() {
        return (NamedReferenceProviders)ServiceManager.getService(NamedReferenceProviders.class);
    }

    public NamedReferenceProviders() {
        EP_NAME.addChangeListener(() -> this.myByHostClass.clear(), (Disposable)ApplicationManager.getApplication());
        EP_NAME.addChangeListener(() -> this.myByTargetClass.clear(), (Disposable)ApplicationManager.getApplication());
    }

    @NotNull
    Collection<XmlNamedReferenceProviderBean> getNamedReferenceProviderBeans(@NotNull XmlNamedReferenceHost element) {
        String hostName = element.getHostName();
        if (hostName == null) {
            return Collections.emptyList();
        }
        return this.byHostClass(element).byHostName(hostName);
    }

    @NotNull
    private ByHostClass byHostClass(@NotNull XmlNamedReferenceHost element) {
        return this.myByHostClass.computeIfAbsent(element.getClass(), NamedReferenceProviders::byHostClassInner);
    }

    @NotNull
    private static ByHostClass byHostClassInner(@NotNull Class<?> hostClass) {
        SmartList result = new SmartList();
        for (XmlNamedReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            if (!bean.getHostElementClass().isAssignableFrom(hostClass)) continue;
            result.add(bean);
        }
        return new ByHostClass((List<XmlNamedReferenceProviderBean>)result);
    }

    @NotNull
    @NotNull Collection<@NotNull PsiSymbolReferenceProvider> getNamedReferenceProviders(@NotNull Symbol target) {
        return this.myByTargetClass.computeIfAbsent(target.getClass(), NamedReferenceProviders::byTargetClassInner);
    }

    @NotNull
    private static Collection<PsiSymbolReferenceProvider> byTargetClassInner(@NotNull Class<?> targetClass) {
        SmartList result = new SmartList();
        for (XmlNamedReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            if (!targetClass.isAssignableFrom(bean.getResolveTargetClass())) continue;
            result.add(bean.getInstance());
        }
        return result;
    }

    private static final class ByHostClass {
        private final Map<String, List<XmlNamedReferenceProviderBean>> myCaseSensitiveMap;
        private final Map<String, List<XmlNamedReferenceProviderBean>> myCaseInsensitiveMap;

        ByHostClass(@NotNull List<XmlNamedReferenceProviderBean> beans) {
            THashMap caseSensitiveMap = new THashMap();
            THashMap caseInsensitiveMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            for (XmlNamedReferenceProviderBean bean : beans) {
                THashMap map = bean.caseSensitive ? caseSensitiveMap : caseInsensitiveMap;
                for (String hostName : bean.getHostNames()) {
                    map.computeIfAbsent(hostName, __ -> new SmartList()).add(bean);
                }
            }
            caseSensitiveMap.compact();
            caseInsensitiveMap.compact();
            this.myCaseSensitiveMap = caseSensitiveMap;
            this.myCaseInsensitiveMap = caseInsensitiveMap;
        }

        @NotNull
        Collection<XmlNamedReferenceProviderBean> byHostName(@NotNull String hostName) {
            return ContainerUtil.concat((List)((List)ObjectUtils.notNull(this.myCaseSensitiveMap.get(hostName), Collections.emptyList())), (List)((List)ObjectUtils.notNull(this.myCaseInsensitiveMap.get(hostName), Collections.emptyList())));
        }
    }
}

