/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigFileSearcher {
    private final MultiMap<Module, PsiFile> myFiles = new MultiMap();
    private final MultiMap<VirtualFile, PsiFile> myJars = new MultiMap();
    private final MultiMap<VirtualFile, PsiFile> myVirtualFiles = new MultiMap();
    @Nullable
    private final Module myModule;
    @NotNull
    private final Project myProject;

    public ConfigFileSearcher(@Nullable Module module, @NotNull Project project) {
        this.myModule = module;
        this.myProject = project;
    }

    public void search() {
        this.searchWithFiles();
    }

    public List<PsiFile> searchWithFiles() {
        this.myFiles.clear();
        this.myJars.clear();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        for (PsiFile file : this.search(this.myModule, this.myProject)) {
            files.add(file);
            VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(file.getVirtualFile());
            if (jar != null) {
                this.myJars.putValue((Object)jar, (Object)file);
                continue;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module != null) {
                this.myFiles.putValue((Object)module, (Object)file);
                continue;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            this.myVirtualFiles.putValue((Object)virtualFile.getParent(), (Object)psiManager.findFile(virtualFile));
        }
        return files;
    }

    public abstract Set<PsiFile> search(@Nullable Module var1, @NotNull Project var2);

    public MultiMap<Module, PsiFile> getFilesByModules() {
        return this.myFiles;
    }

    public MultiMap<VirtualFile, PsiFile> getJars() {
        return this.myJars;
    }

    public MultiMap<VirtualFile, PsiFile> getVirtualFiles() {
        return this.myVirtualFiles;
    }
}

