/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.impl.source.xml.XmlDocumentImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlExtension {
    public static final ExtensionPointName<XmlExtension> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlExtension");

    public static XmlExtension getExtension(@NotNull PsiFile file) {
        return (XmlExtension)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)XmlExtension.calcExtension(file), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static XmlExtension calcExtension(PsiFile file) {
        for (XmlExtension extension : EP_NAME.getExtensionList()) {
            if (!extension.isAvailable(file)) continue;
            return extension;
        }
        return DefaultXmlExtension.DEFAULT_EXTENSION;
    }

    public static XmlExtension getExtensionByElement(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            return XmlExtension.getExtension(psiFile);
        }
        return null;
    }

    public abstract boolean isAvailable(PsiFile var1);

    @NotNull
    public abstract List<TagInfo> getAvailableTagNames(@NotNull XmlFile var1, @NotNull XmlTag var2);

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new TagNameReference(nameElement, startTagFlag);
    }

    public String[] @Nullable [] getNamespacesFromDocument(XmlDocument parent, boolean declarationsExist) {
        return declarationsExist ? (String[][])null : XmlUtil.getDefaultNamespaces(parent);
    }

    public boolean canBeDuplicated(XmlAttribute attribute) {
        return false;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        return false;
    }

    public HighlightInfoType getHighlightInfoType(XmlFile file) {
        return HighlightInfoType.ERROR;
    }

    @Nullable
    public abstract SchemaPrefix getPrefixDeclaration(XmlTag var1, String var2);

    public SearchScope getNsPrefixScope(XmlAttribute declaration) {
        return new LocalSearchScope((PsiElement)declaration.getParent());
    }

    public boolean shouldBeHighlightedAsTag(XmlTag tag) {
        return true;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag tag, XmlTag contextTag, XmlElementDescriptor parentDescriptor) {
        return parentDescriptor.getElementDescriptor(tag, contextTag);
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        return element.getNSDescriptor(namespace, strict);
    }

    @NotNull
    public XmlNSDescriptor wrapNSDescriptor(@NotNull XmlTag element, @NotNull String namespacePrefix, @NotNull XmlNSDescriptor descriptor) {
        if (element instanceof HtmlTag && !(descriptor instanceof HtmlNSDescriptorImpl)) {
            XmlNSDescriptor result = (XmlNSDescriptor)ObjectUtils.doIfNotNull((Object)descriptor.getDescriptorFile(), file -> XmlDocumentImpl.getCachedHtmlNsDescriptor(file, namespacePrefix));
            return (XmlNSDescriptor)ObjectUtils.notNull((Object)result, () -> new HtmlNSDescriptorImpl(descriptor));
        }
        return descriptor;
    }

    @Nullable
    public XmlTag getParentTagForNamespace(XmlTag tag, XmlNSDescriptor namespace) {
        return tag.getParentTag();
    }

    @Nullable
    public XmlFile getContainingFile(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    public XmlNSDescriptor getDescriptorFromDoctype(XmlFile containingFile, XmlNSDescriptor descr) {
        return descr;
    }

    public boolean hasDynamicComponents(PsiElement element) {
        return false;
    }

    public boolean isIndirectSyntax(XmlAttributeDescriptor descriptor) {
        return false;
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor) {
        return descriptor.isRequired();
    }

    public boolean shouldCompleteTag(XmlTag context) {
        return true;
    }

    @NotNull
    public AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlTag tag, @NotNull String attributeName, final @NotNull String defaultAttributeQuote) {
        return new AttributeValuePresentation(){

            @Override
            @NotNull
            public String getPrefix() {
                return defaultAttributeQuote;
            }

            @Override
            @NotNull
            public String getPostfix() {
                return defaultAttributeQuote;
            }
        };
    }

    public boolean isCustomTagAllowed(XmlTag tag) {
        return false;
    }

    public boolean useXmlTagInsertHandler() {
        return true;
    }

    public boolean isCollapsibleTag(XmlTag tag) {
        return false;
    }

    public boolean isSelfClosingTagAllowed(@NotNull XmlTag tag) {
        return false;
    }

    public boolean isSingleTagException(@NotNull XmlTag tag) {
        return false;
    }

    public boolean isValidTagNameChar(char c) {
        return false;
    }

    @NotNull
    public @NotNull List<@NotNull XmlFile> getCharEntitiesDTDs(@NotNull XmlFile file) {
        XmlDocument document = file.getDocument();
        if (HtmlUtil.isHtml5Document(document)) {
            return ContainerUtil.packNullables((Object[])new XmlFile[]{XmlUtil.findXmlFile((PsiFile)file, Html5SchemaProvider.getCharsDtdLocation())});
        }
        if (document != null) {
            FileType ft;
            String namespace;
            XmlNSDescriptor nsDescriptor;
            XmlElementDescriptor descriptor;
            XmlTag rootTag = document.getRootTag();
            if (rootTag != null && (descriptor = rootTag.getDescriptor()) != null && !(descriptor instanceof AnyXmlElementDescriptor)) {
                PsiFile containingFile;
                PsiElement element = descriptor.getDeclaration();
                PsiFile psiFile = containingFile = element != null ? element.getContainingFile() : null;
                if (containingFile instanceof XmlFile) {
                    return Collections.singletonList((XmlFile)containingFile);
                }
            }
            if ((nsDescriptor = document.getDefaultNSDescriptor(namespace = (ft = file.getFileType()) == XHtmlFileType.INSTANCE || ft == StdFileTypes.JSPX ? "http://www.w3.org/1999/xhtml" : "http://www.w3.org/1999/html", true)) != null) {
                return ContainerUtil.packNullables((Object[])new XmlFile[]{nsDescriptor.getDescriptorFile()});
            }
        }
        return Collections.emptyList();
    }

    public static boolean shouldIgnoreSelfClosingTag(@NotNull XmlTag tag) {
        XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)tag);
        return extension != null && extension.isSelfClosingTagAllowed(tag);
    }

    public static boolean isCollapsible(XmlTag tag) {
        XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)tag);
        return extension == null || extension.isCollapsibleTag(tag);
    }

    public static class TagInfo {
        public final String name;
        public final String namespace;

        public TagInfo(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        @Nullable
        public PsiElement getDeclaration() {
            return null;
        }
    }

    public static interface AttributeValuePresentation {
        @NotNull
        public String getPrefix();

        @NotNull
        public String getPostfix();

        default public boolean showAutoPopup() {
            return true;
        }
    }
}

