/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.AddXsiSchemaLocationForExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.FetchExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.IgnoreExtResourceAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ManuallySetupExtResourceAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class URLReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<URLReference> {
    public void registerFixes(@NotNull URLReference ref, @NotNull QuickFixActionRegistrar registrar) {
        registrar.register((IntentionAction)new FetchExtResourceAction());
        registrar.register((IntentionAction)new ManuallySetupExtResourceAction());
        registrar.register((IntentionAction)new IgnoreExtResourceAction());
        PsiElement parentElement = ref.getElement().getParent();
        if (parentElement instanceof XmlAttribute && ((XmlAttribute)parentElement).isNamespaceDeclaration()) {
            registrar.register((IntentionAction)new AddXsiSchemaLocationForExtResourceAction());
        }
    }

    @NotNull
    public Class<URLReference> getReferenceClass() {
        return URLReference.class;
    }
}

