/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaReferencesProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String VALUE_ATTR_NAME = "value";
    @NonNls
    static final String NAME_ATTR_NAME = "name";
    @NonNls
    static final String MEMBER_TYPES_ATTR_NAME = "memberTypes";
    @NonNls
    static final String ITEM_TYPE_ATTR_NAME = "itemType";
    @NonNls
    static final String BASE_ATTR_NAME = "base";
    @NonNls
    static final String GROUP_TAG_NAME = "group";
    @NonNls
    static final String ATTRIBUTE_GROUP_TAG_NAME = "attributeGroup";
    @NonNls
    static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    static final String SIMPLE_TYPE_TAG_NAME = "simpleType";
    @NonNls
    static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    static final String REF_ATTR_NAME = "ref";
    @NonNls
    static final String TYPE_ATTR_NAME = "type";
    @NonNls
    static final String SUBSTITUTION_GROUP_ATTR_NAME = "substitutionGroup";

    public String[] getCandidateAttributeNamesForSchemaReferences() {
        return new String[]{REF_ATTR_NAME, TYPE_ATTR_NAME, BASE_ATTR_NAME, NAME_ATTR_NAME, SUBSTITUTION_GROUP_ATTR_NAME, MEMBER_TYPES_ATTR_NAME, VALUE_ATTR_NAME, ITEM_TYPE_ATTR_NAME};
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return PsiReference.EMPTY_ARRAY;
        }
        String attrName = ((XmlAttribute)parent).getName();
        if (VALUE_ATTR_NAME.equals(attrName)) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (NAME_ATTR_NAME.equals(attrName)) {
            return new PsiReference[]{new NameReference(element)};
        }
        if (MEMBER_TYPES_ATTR_NAME.equals(attrName)) {
            ArrayList<TypeOrElementOrAttributeReference> result = new ArrayList<TypeOrElementOrAttributeReference>(1);
            String text = element.getText();
            int lastIndex = 1;
            int testLength = text.length();
            for (int i = 1; i < testLength; ++i) {
                if (!Character.isWhitespace(text.charAt(i))) continue;
                if (lastIndex != i) {
                    result.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, i)));
                }
                lastIndex = i + 1;
            }
            if (lastIndex != testLength - 1) {
                result.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, testLength - 1)));
            }
            return result.toArray(PsiReference.EMPTY_ARRAY);
        }
        PsiReference prefix = SchemaReferencesProvider.createSchemaPrefixReference(element);
        PsiReference ref = SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, prefix == null ? null : prefix.getCanonicalText());
        if (prefix == null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = ref;
        } else {
            PsiReference[] psiReferenceArray3 = new PsiReference[2];
            psiReferenceArray3[0] = ref;
            psiReferenceArray = psiReferenceArray3;
            psiReferenceArray3[1] = prefix;
        }
        return psiReferenceArray;
    }

    public static PsiReference createTypeOrElementOrAttributeReference(@NotNull PsiElement element) {
        return SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, null);
    }

    public static PsiReference createTypeOrElementOrAttributeReference(@NotNull PsiElement element, String ns) {
        int offset;
        int length = element.getTextLength();
        int n = offset = element instanceof XmlAttributeValue ? XmlUtil.findPrefixByQualifiedName(((XmlAttributeValue)element).getValue()).length() : 0;
        if (offset > 0) {
            ++offset;
        }
        TypeOrElementOrAttributeReference ref = new TypeOrElementOrAttributeReference(element, length >= 2 ? new TextRange(1 + offset, length - 1) : TextRange.EMPTY_RANGE);
        ref.setNamespacePrefix(ns);
        return ref;
    }

    @Nullable
    private static PsiReference createSchemaPrefixReference(PsiElement element) {
        XmlAttributeValue attributeValue;
        String prefix;
        if (element instanceof XmlAttributeValue && !(prefix = XmlUtil.findPrefixByQualifiedName((attributeValue = (XmlAttributeValue)element).getValue())).isEmpty()) {
            return new SchemaPrefixReference((XmlElement)attributeValue, TextRange.from((int)1, (int)prefix.length()), prefix, null);
        }
        return null;
    }

    @Nullable
    public static XmlNSDescriptorImpl findRedefinedDescriptor(XmlTag tag, String text) {
        String localName = XmlUtil.findLocalNameByQualifiedName(text);
        for (XmlTag parentTag = tag.getParentTag(); parentTag != null; parentTag = parentTag.getParentTag()) {
            XmlTag grandParent;
            if (!localName.equals(parentTag.getAttributeValue(NAME_ATTR_NAME)) || (grandParent = parentTag.getParentTag()) == null || !"redefine".equals(grandParent.getLocalName())) continue;
            return XmlNSDescriptorImpl.getRedefinedElementDescriptor(grandParent);
        }
        return null;
    }

    public static class NameReference
    implements PsiReference {
        private final PsiElement myElement;

        public NameReference(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        @NotNull
        public TextRange getRangeInElement() {
            return ElementManipulators.getValueTextRange((PsiElement)this.myElement);
        }

        @Nullable
        public PsiElement resolve() {
            return this.myElement.getParent().getParent();
        }

        @NotNull
        public String getCanonicalText() {
            String text = this.myElement.getText();
            return text.substring(1, text.length() - 1);
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            return ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName.substring(newElementName.indexOf(58) + 1));
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            return null;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
        }

        public boolean isSoft() {
            return true;
        }
    }
}

