/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlInjectedLanguageBlockBuilder
extends InjectedLanguageBlockBuilder {
    private final XmlFormattingPolicy myXmlFormattingPolicy;

    public XmlInjectedLanguageBlockBuilder(XmlFormattingPolicy formattingPolicy) {
        this.myXmlFormattingPolicy = formattingPolicy;
    }

    @NotNull
    public Block createInjectedBlock(@NotNull ASTNode node, @NotNull Block originalBlock, Indent indent, int offset, TextRange range, @Nullable Language language) {
        return new AnotherLanguageBlockWrapper(node, this.myXmlFormattingPolicy, originalBlock, indent, offset, range);
    }

    public Block createBlockBeforeInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
        return new XmlBlock(node, wrap, alignment, this.myXmlFormattingPolicy, indent, range);
    }

    public Block createBlockAfterInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
        return new XmlBlock(node, wrap, alignment, this.myXmlFormattingPolicy, indent, range);
    }

    public CodeStyleSettings getSettings() {
        return this.myXmlFormattingPolicy.getSettings();
    }

    public boolean canProcessFragment(String text, ASTNode injectionHost) {
        IElementType type = injectionHost.getElementType();
        if (type == XmlElementType.XML_TEXT) {
            return true;
        }
        if (type == XmlElementType.XML_COMMENT) {
            return true;
        }
        return text.isEmpty();
    }
}

