/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnotherLanguageBlockWrapper
extends AbstractXmlBlock {
    private final InjectedLanguageBlockWrapper myInjectedBlock;
    private final Indent myIndent;

    public AnotherLanguageBlockWrapper(ASTNode node, XmlFormattingPolicy policy, Block original, Indent indent, int offset, @Nullable TextRange range) {
        super(node, original.getWrap(), original.getAlignment(), policy, false);
        this.myInjectedBlock = new InjectedLanguageBlockWrapper(original, offset, range, null);
        this.myIndent = indent;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    @Override
    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean isTextElement() {
        return true;
    }

    protected List<Block> buildChildren() {
        return this.myInjectedBlock.getSubBlocks();
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myInjectedBlock.getTextRange();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        return this.myInjectedBlock.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return this.myInjectedBlock.getChildAttributes(newChildIndex);
    }
}

