/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.lang.html.structureView.HtmlTagTreeElement;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Html5SectionTreeElement
extends PsiTreeElementBase<XmlTag> {
    private final Computable<? extends Collection<StructureViewTreeElement>> myChildrenComputable;
    private final String myHeader;

    Html5SectionTreeElement(XmlTag tag, Computable<? extends Collection<StructureViewTreeElement>> childrenComputable, @Nullable String header) {
        super((PsiElement)tag);
        this.myChildrenComputable = childrenComputable;
        this.myHeader = header;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        return (Collection)this.myChildrenComputable.compute();
    }

    @Nullable
    public String getPresentableText() {
        if (this.myHeader != null) {
            return HtmlTagTreeElement.normalizeSpacesAndShortenIfLong(this.myHeader);
        }
        XmlTag tag = (XmlTag)this.getElement();
        return tag == null ? null : HtmlTagTreeElement.normalizeSpacesAndShortenIfLong(tag.getValue().getTrimmedText());
    }

    public String getLocationString() {
        return HtmlUtil.getTagPresentation((XmlTag)this.getElement());
    }

    public boolean isSearchInLocationString() {
        return true;
    }
}

