/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.EmmetPreviewUtil;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;

public class EmmetPreviewAction
extends BaseCodeInsightAction
implements DumbAware,
PopupAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
                String templateText = EmmetPreviewUtil.calculateTemplateText(editor, file, true);
                if (StringUtil.isEmpty((String)templateText)) {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)XmlBundle.message((String)"cannot.show.preview.for.given.abbreviation", (Object[])new Object[0]), (String)XmlBundle.message((String)"emmet.preview", (Object[])new Object[0]), null);
                    return;
                }
                EmmetPreviewHint.createHint((EditorEx)editor, templateText, file.getFileType()).showHint();
                EmmetPreviewUtil.addEmmetPreviewListeners(editor, file, true);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return super.isValidForFile(project, editor, file) && ZenCodingTemplate.findApplicableDefaultGenerator(new CustomTemplateCallback(editor, file), false) instanceof XmlZenCodingGenerator;
    }
}

