/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlNSColorProvider;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;

public class XmlNamespaceAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String namespace = tag.getNamespace();
            for (XmlNSColorProvider provider : XmlNSColorProvider.EP_NAME.getExtensionList()) {
                TextRange endTagRange;
                TextAttributesKey key = provider.getKeyForNamespace(namespace, (XmlElement)tag);
                if (key == null) continue;
                TextRange range = XmlTagUtil.getStartTagRange((XmlTag)tag);
                if (range != null) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(key).create();
                }
                if ((endTagRange = XmlTagUtil.getEndTagRange((XmlTag)tag)) != null) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(endTagRange).textAttributes(key).create();
                }
                return;
            }
        }
    }
}

