/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TextToCDataIntention
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return XmlBundle.message((String)"convert.text.to.cdata", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return file.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && TextToCDataIntention.getText(editor, file) != null && !file.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        int pos;
        PsiElement textElement = TextToCDataIntention.getText(editor, file);
        if (textElement == null) {
            return;
        }
        ArrayList<PsiElement> texts = new ArrayList<PsiElement>();
        PsiElement curr = textElement.getPrevSibling();
        while (TextToCDataIntention.isText(curr)) {
            texts.add(0, curr);
            curr = curr.getPrevSibling();
        }
        texts.add(textElement);
        curr = textElement.getNextSibling();
        while (TextToCDataIntention.isText(curr)) {
            texts.add(curr);
            curr = curr.getNextSibling();
        }
        StringBuilder text = new StringBuilder();
        for (PsiElement element : texts) {
            text.append(StringUtil.unescapeXmlEntities((String)element.getText()));
        }
        int start = 0;
        while ((pos = text.indexOf("]]>", start)) >= 0) {
            text.insert(pos + 1, "]]><![CDATA[");
            start = pos + 2;
        }
        int begin = ((PsiElement)texts.get(0)).getTextRange().getStartOffset();
        String replacement = "<![CDATA[" + text + "]]>";
        editor.getDocument().replaceString(begin, ((PsiElement)texts.get(texts.size() - 1)).getTextRange().getEndOffset(), (CharSequence)replacement);
        editor.getCaretModel().moveToOffset(begin + replacement.length());
    }

    private static PsiElement getText(Editor editor, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (TextToCDataIntention.isText(parent)) {
            return parent;
        }
        element = file.findElementAt(offset - 1);
        PsiElement psiElement2 = parent = element != null ? element.getParent() : null;
        if (TextToCDataIntention.isText(parent)) {
            return parent;
        }
        return null;
    }

    private static boolean isText(PsiElement element) {
        if (element instanceof XmlText) {
            return true;
        }
        return element instanceof XmlEntityRef && element.getParent() instanceof XmlText;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

