/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class TestMethod
extends TestObject {
    TestMethod(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = this.createDefaultJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        javaParameters.getProgramParametersList().add(data.getMainClassName() + "," + data.getMethodNameWithSignature());
        return javaParameters;
    }

    protected void collectPackagesToOpen(List<String> options) {
        options.add(StringUtil.getPackageName((String)this.getConfiguration().getPersistentData().getMainClassName()));
    }

    protected JavaParameters createDefaultJavaParameters() throws ExecutionException {
        return super.createJavaParameters();
    }

    @Override
    public String suggestActionName() {
        return ProgramRunnerUtil.shortenName((String)this.getConfiguration().getPersistentData().getMethodName(), (int)2) + "()";
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, final JUnitConfiguration configuration) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (!method.getName().equals(configuration.getPersistentData().getMethodName())) {
                return null;
            }
            if (!method.getContainingClass().equals(configuration.myClass.getPsiElement())) {
                return null;
            }
            class Listener
            extends RefactoringElementAdapter
            implements UndoRefactoringElementListener {
                Listener() {
                }

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    boolean generatedName = configuration.isGeneratedName();
                    configuration.getPersistentData().setTestMethod((Location<? extends PsiMethod>)PsiLocation.fromPsiElement((PsiElement)((PsiMethod)newElement)));
                    if (generatedName) {
                        configuration.setGeneratedName();
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    int methodIdx = oldQualifiedName.indexOf("#") + 1;
                    if (methodIdx <= 0 || methodIdx >= oldQualifiedName.length()) {
                        return;
                    }
                    boolean generatedName = configuration.isGeneratedName();
                    configuration.getPersistentData().METHOD_NAME = oldQualifiedName.substring(methodIdx);
                    if (generatedName) {
                        configuration.setGeneratedName();
                    }
                }
            }
            return new Listener();
        }
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, configuration.myClass);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        if (testMethod == null) {
            return false;
        }
        if (testClass == null) {
            return false;
        }
        JUnitConfiguration.Data data = configuration.getPersistentData();
        return Objects.equals(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)testClass), data.getMainClassName()) && Objects.equals(JUnitConfiguration.Data.getMethodPresentation(testMethod), data.getMethodNameWithSignature());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        String testClass = data.getMainClassName();
        PsiClass psiClass = configurationModule.checkModuleAndClassName(testClass, JUnitBundle.message("no.test.class.specified.error.text", new Object[0]));
        String methodName = data.getMethodName();
        String methodNameWithSignature = data.getMethodNameWithSignature();
        if (methodName == null || methodName.trim().length() == 0) {
            throw new RuntimeConfigurationError(JUnitBundle.message("method.name.not.specified.error.message", new Object[0]));
        }
        JUnitUtil.TestMethodFilter filter = new JUnitUtil.TestMethodFilter(psiClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
            if (filter.value(method) && Objects.equals(methodNameWithSignature, JUnitConfiguration.Data.getMethodPresentation(method))) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            testAnnotated = true;
        }
        if (!found) {
            throw new RuntimeConfigurationWarning(JUnitBundle.message("test.method.doesnt.exist.error.message", methodName));
        }
        if (!(testAnnotated || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.junit.runner.RunWith", (int)1) || MetaAnnotationUtil.isMetaAnnotatedInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton("org.junit.platform.commons.annotation.Testable")))) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)configurationModule.getModule());
                if (!psiClass.isInheritor(testCaseClass, true)) {
                    throw new RuntimeConfigurationError(JUnitBundle.message("class.isnt.inheritor.of.testcase.error.message", testClass));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                throw new RuntimeConfigurationWarning(JUnitBundle.message("junit.jar.not.found.in.module.class.path.error.message", configurationModule.getModuleName()));
            }
        }
    }
}

