/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.ddmlib.Client;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.ProgressReporter;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointHandler;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Ref;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNativeHybridDebugProcessBase
extends AndroidNativeAppDebugProcess {
    private final StepIntoNativeBreakpointHandler myStepIntoNativeBreakpointHandler = this.createStepIntoNativeHandler();

    public AndroidNativeHybridDebugProcessBase(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @Nullable JdwpConnector jdwpConnector, @NotNull Client client, @NotNull ProgressReporter progressReporter, boolean detachOnStop, @NotNull Abi lldbServerAbi) throws ExecutionException {
        super(sessionId, parameters, session, consoleBuilder, printer, sessionStarter, jdwpConnector, client, progressReporter, detachOnStop, lldbServerAbi);
    }

    @NotNull
    private StepIntoNativeBreakpointHandler createStepIntoNativeHandler() {
        return new StepIntoNativeBreakpointHandler(this, StepIntoNativeBreakpointType.class);
    }

    private void removeStepIntoNativeBreakpoint(XBreakpointManager bpManager, XBreakpoint<StepIntoNativeBreakpointType.Properties> bp) {
        bpManager.removeBreakpoint(bp);
        this.myStepIntoNativeBreakpointHandler.unregisterBreakpoint(bp, false);
    }

    @NotNull
    public XBreakpoint<StepIntoNativeBreakpointType.Properties> registerStepIntoNativeBreakpoint(@NotNull String jniMethodName, long tid) {
        StepIntoNativeBreakpointType.Properties props = new StepIntoNativeBreakpointType.Properties(jniMethodName, tid);
        Ref bpRef = new Ref();
        AndroidNativeHybridDebugProcessBase.getApp().invokeAndWait(() -> AndroidNativeHybridDebugProcessBase.getApp().runWriteAction(() -> {
            XBreakpoint bp = this.getBreakpointManager().addBreakpoint((XBreakpointType)StepIntoNativeBreakpointType.INSTANCE, (XBreakpointProperties)props);
            this.myStepIntoNativeBreakpointHandler.registerBreakpoint((XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
            bpRef.set((Object)bp);
        }), ModalityState.defaultModalityState());
        return (XBreakpoint)bpRef.get();
    }

    public void removeAllStepIntoNativeBreakpoints() {
        LinkedList bps = Lists.newLinkedList();
        AndroidNativeHybridDebugProcessBase.getApp().runReadAction(() -> bps.addAll(this.getBreakpointManager().getBreakpoints((XBreakpointType)StepIntoNativeBreakpointType.INSTANCE)));
        if (bps.isEmpty()) {
            return;
        }
        AndroidNativeHybridDebugProcessBase.getApp().invokeAndWait(() -> AndroidNativeHybridDebugProcessBase.getApp().runWriteAction(() -> {
            XBreakpointManager bpManager = this.getBreakpointManager();
            for (XBreakpoint bp : bps) {
                this.removeStepIntoNativeBreakpoint(bpManager, (XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
            }
        }), ModalityState.defaultModalityState());
    }

    public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int number) {
        XBreakpoint bp = this.myStepIntoNativeBreakpointHandler.getCodepoint(number);
        if (bp == null) {
            super.handleBreakpoint(stopPlace, number);
            return;
        }
        ((StepIntoNativeBreakpointType.Properties)bp.getProperties()).setCalled(true);
        AndroidNativeHybridDebugProcessBase.getApp().invokeAndWait(() -> AndroidNativeHybridDebugProcessBase.getApp().runWriteAction(() -> this.removeStepIntoNativeBreakpoint(this.getBreakpointManager(), (XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp)), ModalityState.defaultModalityState());
        this.handleCodepoint(stopPlace, bp);
    }
}

