/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.cosmetics.JniParameterTypeHintsPassFactory;
import com.android.tools.ndk.jni.service.JniEditorSettings;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/ndk/jni/inspections/ToggleJniParameterTypeHintIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "android-ndk"})
public final class ToggleJniParameterTypeHintIntention
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        return JniEditorSettings.Companion.getInstance().getShowJniParameterTypeHints() ? "Do not show JNI parameter type hints." : "Show JNI parameter type hints.";
    }

    @NotNull
    public String getFamilyName() {
        return "JNI Parameter Type Hints";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (!NdkHelper.isNdkProject(project) || !(file instanceof OCFile)) {
            return false;
        }
        PsiElement elementAtCursor = file.findElementAt(editor.getCaretModel().getOffset());
        PsiElement psiElement = elementAtCursor;
        return (psiElement != null && (psiElement = psiElement.getParent()) != null && (psiElement = psiElement.getParent()) != null ? psiElement.getParent() : null) instanceof OCParameterDeclaration && SetsKt.setOf((Object[])new String[]{"jobject", "jthrowable", "jclass", "jobjectArray"}).contains(elementAtCursor.getText());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        JniEditorSettings jniEditorSettings;
        jniEditorSettings.setShowJniParameterTypeHints(!(jniEditorSettings = JniEditorSettings.Companion.getInstance()).getShowJniParameterTypeHints());
        JniParameterTypeHintsPassFactory.Companion.forceParameterTypeHintsUpdateOnNextPass();
        ((InlayHintsSettings.SettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(InlayHintsSettings.Companion.getINLAY_SETTINGS_CHANGED())).settingsChanged();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

