/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniGetMethodIdInspection$buildVisitor$;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.GetMethodIdCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmArrayType;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeKt;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniGetMethodIdInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/jetbrains/cidr/lang/psi/visitors/OCVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspect", "", "declaredClassType", "Lcom/android/tools/ndk/jni/model/JvmType;", "methodSourceClass", "Lcom/intellij/psi/PsiClass;", "call", "Lcom/android/tools/ndk/jni/model/GetMethodIdCall;", "android-ndk"})
public final class JniGetMethodIdInspection
extends JniInspectionTool {
    @NotNull
    public OCVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return new OCVisitor(this_$iv, this, holder){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ JniGetMethodIdInspection this$0;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            {
                this.this$0$inline_fun = this$0;
                this.this$0 = jniGetMethodIdInspection;
                this.$holder$inlined = problemsHolder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof GetMethodIdCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (GetMethodIdCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call2 = jniCall2;
                JniInspectionTool this_$iv = this.this$0$inline_fun;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
                int inverseSampleRate$iv$iv = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call3;
                    JniUsageEventReporter $this$reportJniPerf$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    JniInfoInferencer inferencer = (JniInfoInferencer)expression.getProject().getComponent(JniInfoInferencer.class);
                    GetMethodIdCall getMethodIdCall = (GetMethodIdCall)call2;
                    JniInfoInferencer $this$visitJniCall = inferencer;
                    boolean bl3 = false;
                    if (call3.getMethodNameExpression() != null && call3.getMethodTypeExpression() != null) {
                        InspectionUtilsKt.inspectClass($this$visitJniCall, this.$holder$inlined, call3.getClassExpression(), (Function2<? super JniInfoInferencer, ? super JvmType, Unit>)((Function2)new Function2<JniInfoInferencer, JvmType, Unit>((GetMethodIdCall)call3, this){
                            final /* synthetic */ GetMethodIdCall $call;
                            final /* synthetic */ buildVisitor$$inlined$visitJniCall$android_ndk$1 this$0;
                            {
                                this.$call = getMethodIdCall;
                                this.this$0 = var2_2;
                                super(2);
                            }

                            public final void invoke(@NotNull JniInfoInferencer $this$inspectClass, @NotNull JvmType classType) {
                                JvmType jvmType = classType;
                                if (jvmType instanceof JvmPrimitiveType) {
                                    InspectionUtilsKt.registerOcProblem(this.this$0.$holder$inlined, (PsiElement)this.$call.getClassExpression(), '\'' + classType.toShortJavaType() + "' does not have any member methods.", ProblemHighlightType.GENERIC_ERROR, new JniLocalQuickFix[0]);
                                } else if (jvmType instanceof JvmArrayType) {
                                    PsiClass psiClass = JniInfoInferencer.findPsiClass$default($this$inspectClass, JvmTypeKt.getOBJECT_TYPE(), false, 1, null);
                                    if (psiClass == null) {
                                        return;
                                    }
                                    JniGetMethodIdInspection.access$inspect(this.this$0.this$0, classType, psiClass, this.$call, this.this$0.$holder$inlined);
                                } else if (jvmType instanceof JvmObjectType) {
                                    PsiClass psiClass = JniInfoInferencer.findPsiClass$default($this$inspectClass, classType, false, 1, null);
                                    if (psiClass == null) {
                                        return;
                                    }
                                    JniGetMethodIdInspection.access$inspect(this.this$0.this$0, classType, psiClass, this.$call, this.this$0.$holder$inlined);
                                }
                            }
                        }));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (JniUtilsKt.access$getRandom$p().nextInt(inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspect(JvmType declaredClassType, PsiClass methodSourceClass, GetMethodIdCall call2, ProblemsHolder holder) {
        boolean bl;
        List matchedMethodInfos;
        block13: {
            Iterator $this$filterTo$iv$iv;
            DataSource dataSource;
            DataSource dataSource2;
            OCExpression oCExpression = call2.getMethodNameExpression();
            if (oCExpression == null) {
                Intrinsics.throwNpe();
            }
            if (!((dataSource2 = DataSourceKt.getDataSource((OCElement)oCExpression)) instanceof StringDataSource)) {
                dataSource2 = null;
            }
            StringDataSource stringDataSource = (StringDataSource)dataSource2;
            if (stringDataSource == null) {
                return;
            }
            StringDataSource methodNameDataSource = stringDataSource;
            OCExpression oCExpression2 = call2.getMethodTypeExpression();
            if (oCExpression2 == null) {
                Intrinsics.throwNpe();
            }
            if (!((dataSource = DataSourceKt.getDataSource((OCElement)oCExpression2)) instanceof StringDataSource)) {
                dataSource = null;
            }
            StringDataSource stringDataSource2 = (StringDataSource)dataSource;
            if (stringDataSource2 == null) {
                return;
            }
            StringDataSource methodTypeDataSource = stringDataSource2;
            String methodName = methodNameDataSource.getString();
            List<JvmMethodInfo> matchedMethodInfosByName = JniUtilsKt.findAllMethodsByName(methodSourceClass, methodName);
            if (matchedMethodInfosByName.isEmpty()) {
                ProblemHighlightType problemType = Intrinsics.areEqual((Object)methodNameDataSource.getSourceExpression(), (Object)call2.getMethodNameExpression()) ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call2.getMethodNameExpression(), "Class '" + declaredClassType.toShortJavaType() + "' has no method named '" + methodName + "'.", problemType, new JniLocalQuickFix[0]);
                return;
            }
            Iterable $this$filter$iv = matchedMethodInfosByName;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                JvmMethodInfo it = (JvmMethodInfo)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getMethodType(), (Object)methodTypeDataSource.getString())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            matchedMethodInfos = (List)destination$iv$iv;
            if (matchedMethodInfos.isEmpty()) {
                JvmMethodInfo uniqueMatch = (JvmMethodInfo)CollectionsKt.singleOrNull(matchedMethodInfosByName);
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)call2.getMethodTypeExpression(), uniqueMatch == null ? "The type specifier does not match any version of the overloaded method '" + methodName + "'." : "The type specifier does not match method '" + uniqueMatch.getDescription() + "'.", ProblemHighlightType.GENERIC_ERROR, this.quickFix("Fix type specifier in JNI GetMethodID call", "Fix type specifier of method '" + methodName + '\'', (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(matchedMethodInfosByName){
                    final /* synthetic */ List $matchedMethodInfosByName;

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean invoke(@NotNull Project $noName_0, @NotNull ProblemDescriptor descriptor) {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = this.$matchedMethodInfosByName;
                        ProblemDescriptor problemDescriptor = descriptor;
                        boolean $i$f$map = false;
                        void var5_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            String string = JniUtilsKt.quoted(it.getMethodType());
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv;
                        return InspectionUtilsKt.replaceAtHighlighted(problemDescriptor, (List<String>)collection);
                    }
                    {
                        this.$matchedMethodInfosByName = list;
                        super(2);
                    }
                })));
                return;
            }
            Iterable $this$none$iv = matchedMethodInfos;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    JvmMethodInfo it = (JvmMethodInfo)element$iv;
                    boolean bl3 = false;
                    if (!(it.isStatic() == call2.isStatic())) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            JvmMethodInfo matchedMethodInfo = (JvmMethodInfo)CollectionsKt.first((List)matchedMethodInfos);
            boolean shouldBeStatic = matchedMethodInfo.isStatic();
            GetMethodIdCall correctCall = call2.toggleStaticity();
            InspectionUtilsKt.registerOcProblem(holder, call2.getFunctionIdentifier(), matchedMethodInfo.isConstructor() ? "A constructor ID should be acquired by calling 'GetMethodID'." : '\'' + matchedMethodInfo.getDescription() + "' is " + (shouldBeStatic ? "a static" : "an instance") + " method and should be " + "acquired by '" + correctCall.getFunctionName() + "'.", ProblemHighlightType.GENERIC_ERROR, this.quickFix("Fix JNI GetMethodID call", "Replace with '" + correctCall.getFunctionName() + '\'', (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(correctCall){
                final /* synthetic */ GetMethodIdCall $correctCall;

                public final boolean invoke(@NotNull Project $noName_0, @NotNull ProblemDescriptor descriptor) {
                    return InspectionUtilsKt.replaceAtHighlighted(descriptor, this.$correctCall.getFunctionName());
                }
                {
                    this.$correctCall = getMethodIdCall;
                    super(2);
                }
            })));
        }
    }

    public JniGetMethodIdInspection() {
        super(JniInspectionEvent.JniInspectionType.FIND_METHOD_INSPECTION_EVENT);
    }

    public static final /* synthetic */ void access$inspect(JniGetMethodIdInspection $this, JvmType declaredClassType, PsiClass methodSourceClass, GetMethodIdCall call2, ProblemsHolder holder) {
        $this.inspect(declaredClassType, methodSourceClass, call2, holder);
    }
}

