/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.utils.debug.dwarf.DwarfReader;
import org.eclipse.cdt.utils.elf.Elf;
import org.jetbrains.annotations.NotNull;

public class SourceRootsExtractor
implements AutoCloseable {
    @NotNull
    public List<String> extractSourceRoots(@NotNull File path) throws IOException {
        HashSet<String> sourceRoots = new HashSet<String>();
        this.doExtractSourceRoots(path, sourceRoots);
        return SourceRootsExtractor.mergePaths(sourceRoots);
    }

    private void doExtractSourceRoots(@NotNull File path, @NotNull Set<String> sourceRoots) throws IOException {
        if (path.isDirectory()) {
            for (File child : FileUtil.notNullize((File[])path.listFiles())) {
                this.doExtractSourceRoots(child, sourceRoots);
            }
        } else {
            sourceRoots.addAll(this.extractSourceRootsFromFile(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<String> extractSourceRootsFromFile(@NotNull File filePath) throws IOException {
        if (!filePath.exists() || !"so".equals(FileUtilRt.getExtension((String)filePath.getName()))) {
            return Collections.emptyList();
        }
        Elf elf = new Elf(filePath.getPath());
        try {
            Elf.Section debugInfo = elf.getSectionByName(".debug_info");
            if (debugInfo == null) {
                SourceRootsExtractor.getLog().info("No debug info in the ELF lib");
                List<String> list = Collections.emptyList();
                return list;
            }
            DwarfReader reader = new DwarfReader(elf);
            String[] sourceFilePaths = reader.getSourceFiles();
            if (sourceFilePaths == null) {
                SourceRootsExtractor.getLog().info("No source files can be found in ELF lib");
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = SourceRootsExtractor.computeRootPathsForFiles(Arrays.stream(sourceFilePaths));
            return list;
        }
        finally {
            elf.dispose();
        }
    }

    @Override
    public void close() {
        System.gc();
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(SourceRootsExtractor.class);
    }

    @NotNull
    static List<String> computeRootPathsForFiles(@NotNull Stream<String> filePaths) {
        HashSet<String> folderPaths = new HashSet<String>();
        filePaths.forEach(filePath -> {
            String parentPath = PathUtil.getParentPath((String)filePath);
            folderPaths.add(parentPath);
        });
        return SourceRootsExtractor.mergePaths(folderPaths);
    }

    @NotNull
    private static List<String> mergePaths(@NotNull Set<String> paths) {
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList sortedPaths = paths.stream().sorted().collect(Collectors.toCollection(ArrayList::new));
        ArrayList<String> result = new ArrayList<String>(paths.size());
        String current = (String)sortedPaths.get(0);
        for (int i = 1; i < sortedPaths.size(); ++i) {
            String folder = (String)sortedPaths.get(i);
            if (folder.startsWith(current) && folder.length() >= current.length() + 1 && (folder.charAt(current.length()) == '/' || folder.charAt(current.length()) == '\\')) continue;
            result.add(current);
            current = folder;
        }
        result.add(current);
        return result;
    }
}

