/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.conversions.RecursiveApplicableConversionBase;
import org.jetbrains.kotlin.nj2k.tree.JKAnnotation;
import org.jetbrains.kotlin.nj2k.tree.JKAnnotationList;
import org.jetbrains.kotlin.nj2k.tree.JKBodyStub;
import org.jetbrains.kotlin.nj2k.tree.JKClass;
import org.jetbrains.kotlin.nj2k.tree.JKMethod;
import org.jetbrains.kotlin.nj2k.tree.JKOtherModifierElement;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.tree.OtherModifier;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/FunctionalInterfacesConverter;", "Lorg/jetbrains/kotlin/nj2k/conversions/RecursiveApplicableConversionBase;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "kotlin.j2k.new"})
public final class FunctionalInterfacesConverter
extends RecursiveApplicableConversionBase {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element) {
        JKAnnotation functionalInterfaceMarker;
        block14: {
            block13: {
                Object v1;
                block12: {
                    void $this$singleOrNull$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (!this.getContext().getFunctionalInterfaceConversionEnabled()) {
                        return this.recurse(element);
                    }
                    if (!(element instanceof JKClass)) {
                        return this.recurse(element);
                    }
                    if (((JKClass)element).getClassKind() != JKClass.ClassKind.INTERFACE) {
                        return this.recurse(element);
                    }
                    Collection collection = ((JKClass)element).getInheritance().getExtends();
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        return this.recurse(element);
                    }
                    JKAnnotation jKAnnotation = ExpressionsKt.annotationByFqName(((JKClass)element).getAnnotationList(), "java.lang.FunctionalInterface");
                    if (jKAnnotation == null) {
                        return this.recurse(element);
                    }
                    functionalInterfaceMarker = jKAnnotation;
                    Iterable $this$filterIsInstance$iv = ((JKClass)element).getClassBody().getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JKMethod)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        JKMethod it = (JKMethod)element$iv;
                        boolean bl2 = false;
                        if (!(it.getBlock() instanceof JKBodyStub)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block12;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                JKMethod samMethod = v1;
                if (samMethod == null) break block13;
                Collection collection = samMethod.getTypeParameterList().getTypeParameters();
                boolean bl = false;
                if (!(!collection.isEmpty())) break block14;
            }
            return this.recurse(element);
        }
        JKClass jKClass = (JKClass)element;
        jKClass.setOtherModifierElements(CollectionsKt.plus((Collection)jKClass.getOtherModifierElements(), (Object)new JKOtherModifierElement(OtherModifier.FUN)));
        JKAnnotationList jKAnnotationList = ((JKClass)element).getAnnotationList();
        jKAnnotationList.setAnnotations(CollectionsKt.minus((Iterable)jKAnnotationList.getAnnotations(), (Object)functionalInterfaceMarker));
        return this.recurse(element);
    }

    public FunctionalInterfacesConverter(@NotNull NewJ2kConverterContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }
}

