/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service.impl;

import com.intellij.util.ConcurrencyUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.service.SharedThreadPool;

public class SharedThreadPoolImpl
extends SharedThreadPool {
    private final ExecutorService myService = Executors.newCachedThreadPool(ConcurrencyUtil.newNamedThreadFactory((String)"JPS thread pool", (boolean)true, (int)5));

    public void execute(@NotNull Runnable command) {
        this.myService.execute(command);
    }

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable action) {
        return this.myService.submit(() -> {
            try {
                action.run();
            }
            finally {
                Thread.interrupted();
            }
        });
    }

    public void shutdown() {
        this.myService.shutdown();
    }

    @NotNull
    public List<Runnable> shutdownNow() {
        return this.myService.shutdownNow();
    }

    public boolean isShutdown() {
        return this.myService.isShutdown();
    }

    public boolean isTerminated() {
        return this.myService.isTerminated();
    }

    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return this.myService.awaitTermination(timeout, unit);
    }

    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        return this.myService.submit(task);
    }

    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        return this.myService.submit(task, result);
    }

    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        return this.myService.submit(task);
    }

    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.myService.invokeAll(tasks);
    }

    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return this.myService.invokeAll(tasks, timeout, unit);
    }

    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.myService.invokeAny(tasks);
    }

    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.myService.invokeAny(tasks, timeout, unit);
    }
}

