/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.plugin.JpsPluginManager;
import org.jetbrains.jps.service.JpsServiceManager;

public class JpsServiceManagerImpl
extends JpsServiceManager {
    private final ConcurrentMap<Class, Object> myServices = new ConcurrentHashMap<Class, Object>(16, 0.75f, 1);
    private final ConcurrentMap<Class, List<?>> myExtensions = new ConcurrentHashMap(16, 0.75f, 1);
    private final AtomicInteger myModificationStamp = new AtomicInteger(0);
    private volatile JpsPluginManager myPluginManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> serviceClass) {
        Object service = this.myServices.get(serviceClass);
        if (service == null) {
            ConcurrentMap<Class, Object> concurrentMap = this.myServices;
            synchronized (concurrentMap) {
                service = this.myServices.get(serviceClass);
                if (service == null) {
                    Iterator<T> iterator = ServiceLoader.load(serviceClass, serviceClass.getClassLoader()).iterator();
                    if (!iterator.hasNext()) {
                        throw new ServiceConfigurationError("Implementation for " + serviceClass + " not found");
                    }
                    T loadedService = iterator.next();
                    if (iterator.hasNext()) {
                        throw new ServiceConfigurationError("More than one implementation for " + serviceClass + " found: " + loadedService.getClass() + " and " + iterator.next().getClass());
                    }
                    service = this.myServices.putIfAbsent(serviceClass, loadedService);
                    if (service == null) {
                        service = loadedService;
                    }
                }
            }
        }
        return (T)service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Iterable<T> getExtensions(Class<T> extensionClass) {
        ArrayList<T> cached;
        ArrayList<T> arrayList = cached = this.cleanupExtensionCache() ? null : (ArrayList<T>)this.myExtensions.get(extensionClass);
        if (cached == null) {
            ConcurrentMap<Class, List<?>> concurrentMap = this.myExtensions;
            synchronized (concurrentMap) {
                ArrayList<T> extensions;
                cached = (List)this.myExtensions.get(extensionClass);
                if (cached == null && (cached = (List)this.myExtensions.putIfAbsent(extensionClass, extensions = new ArrayList<T>(this.loadExtensions(extensionClass)))) == null) {
                    cached = extensions;
                }
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public boolean cleanupExtensionCache() {
        ConcurrentMap<Class, List<?>> concurrentMap = this.myExtensions;
        synchronized (concurrentMap) {
            int stamp;
            JpsPluginManager manager = this.myPluginManager;
            if (manager != null && this.myModificationStamp.getAndSet(stamp = manager.getModificationStamp()) != stamp) {
                this.myExtensions.clear();
                return true;
            }
            return false;
        }
    }

    @NotNull
    private <T> Collection<T> loadExtensions(Class<T> extensionClass) {
        JpsPluginManager pluginManager = this.myPluginManager;
        if (pluginManager == null || !pluginManager.isFullyLoaded()) {
            Iterator<JpsPluginManager> managers = ServiceLoader.load(JpsPluginManager.class, JpsPluginManager.class.getClassLoader()).iterator();
            if (managers.hasNext()) {
                try {
                    pluginManager = managers.next();
                }
                catch (ServiceConfigurationError e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)cause;
                    }
                    throw e;
                }
                if (managers.hasNext()) {
                    throw new ServiceConfigurationError("More than one implementation of " + JpsPluginManager.class + " found: " + pluginManager.getClass() + " and " + managers.next().getClass());
                }
            } else {
                pluginManager = new SingleClassLoaderPluginManager();
            }
            this.myPluginManager = pluginManager;
        }
        return pluginManager.loadExtensions(extensionClass);
    }

    private static class SingleClassLoaderPluginManager
    extends JpsPluginManager {
        private SingleClassLoaderPluginManager() {
        }

        @Override
        @NotNull
        public <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
            ServiceLoader<T> loader = ServiceLoader.load(extensionClass, extensionClass.getClassLoader());
            return ContainerUtil.newArrayList(loader);
        }

        @Override
        public boolean isFullyLoaded() {
            return true;
        }

        @Override
        public int getModificationStamp() {
            return 0;
        }
    }
}

