/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java.compiler;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsJavaCompilerNotNullableSerializer
extends JpsProjectExtensionSerializer {
    public JpsJavaCompilerNotNullableSerializer() {
        super("misc.xml", "NullableNotNullManager");
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
        ArrayList<String> annoNames = new ArrayList<String>();
        for (Element option : componentTag.getChildren("instrumentedNotNulls")) {
            for (Element item : option.getChildren("option")) {
                ContainerUtil.addIfNotNull(annoNames, (Object)item.getAttributeValue("value"));
            }
        }
        if (annoNames.isEmpty()) {
            annoNames.add(NotNull.class.getName());
        }
        configuration.setNotNullAnnotations(annoNames);
    }

    @Override
    public void loadExtensionWithDefaultSettings(@NotNull JpsProject project) {
        JpsJavaExtensionService.getInstance().getCompilerConfiguration(project).setNotNullAnnotations(Collections.singletonList(NotNull.class.getName()));
    }

    @Override
    public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
    }
}

