/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementContainer;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementParameterizedCreator;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementContainerEx;

public class JpsElementContainerImpl
extends JpsElementContainerEx
implements JpsElementContainer {
    private final Object myDataLock = new Object();
    private final Map<JpsElementChildRole<?>, JpsElement> myElements = new Object2ObjectOpenHashMap(1);
    @NotNull
    private final JpsCompositeElementBase<?> myParent;

    public JpsElementContainerImpl(@NotNull JpsCompositeElementBase<?> parent) {
        this.myParent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpsElementContainerImpl(@NotNull JpsElementContainerEx original, @NotNull JpsCompositeElementBase<?> parent) {
        this.myParent = parent;
        Object object = original.getDataLock();
        synchronized (object) {
            for (Map.Entry entry : original.getElementsMap().entrySet()) {
                JpsElementChildRole role = (JpsElementChildRole)entry.getKey();
                JpsElement copy = ((JpsElement)entry.getValue()).getBulkModificationSupport().createCopy();
                JpsElementBase.setParent((JpsElement)copy, this.myParent);
                this.myElements.put(role, copy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JpsElement> T getChild(@NotNull JpsElementChildRole<T> role) {
        Object object = this.myDataLock;
        synchronized (object) {
            return (T)this.myElements.get(role);
        }
    }

    @NotNull
    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T setChild(@NotNull K role, @NotNull P param) {
        JpsElement child = ((JpsElementParameterizedCreator)role).create(param);
        return (T)this.setChild(role, child);
    }

    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T setChild(@NotNull K role) {
        JpsElement child = ((JpsElementCreator)role).create();
        return (T)this.setChild(role, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T getOrSetChild(@NotNull K role) {
        JpsElement added;
        block6: {
            JpsElement jpsElement;
            added = null;
            try {
                Object object = this.myDataLock;
                // MONITORENTER : object
                JpsElement cached = this.myElements.get(role);
                if (cached == null) break block6;
                jpsElement = cached;
                // MONITOREXIT : object
                if (added == null) return (T)jpsElement;
                this.fireChildSet(role, added);
            }
            catch (Throwable throwable) {
                if (added == null) throw throwable;
                this.fireChildSet(role, added);
                throw throwable;
            }
            return (T)jpsElement;
        }
        JpsElement jpsElement = added = this.putChild(role, ((JpsElementCreator)role).create());
        // MONITOREXIT : object
        if (added == null) return (T)jpsElement;
        this.fireChildSet(role, added);
        return (T)jpsElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T getOrSetChild(@NotNull K role, @NotNull Supplier<P> param) {
        JpsElement added;
        block6: {
            JpsElement jpsElement;
            added = null;
            try {
                Object object = this.myDataLock;
                // MONITORENTER : object
                JpsElement cached = this.myElements.get(role);
                if (cached == null) break block6;
                jpsElement = cached;
                // MONITOREXIT : object
                if (added == null) return (T)jpsElement;
                this.fireChildSet(role, added);
            }
            catch (Throwable throwable) {
                if (added == null) throw throwable;
                this.fireChildSet(role, added);
                throw throwable;
            }
            return (T)jpsElement;
        }
        JpsElement jpsElement = added = this.putChild(role, ((JpsElementParameterizedCreator)role).create(param.get()));
        // MONITOREXIT : object
        if (added == null) return (T)jpsElement;
        this.fireChildSet(role, added);
        return (T)jpsElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JpsElement> T setChild(JpsElementChildRole<T> role, T child) {
        try {
            Object object = this.myDataLock;
            synchronized (object) {
                T t = this.putChild(role, child);
                return t;
            }
        }
        finally {
            this.fireChildSet(role, child);
        }
    }

    @NotNull
    private <T extends JpsElement> T putChild(JpsElementChildRole<T> role, T child) {
        JpsElementBase.setParent(child, this.myParent);
        this.myElements.put(role, child);
        return child;
    }

    private <T extends JpsElement> void fireChildSet(JpsElementChildRole<T> role, T child) {
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementAdded(child, role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JpsElement> void removeChild(@NotNull JpsElementChildRole<T> role) {
        JpsElement removed;
        Object object = this.myDataLock;
        synchronized (object) {
            removed = this.myElements.remove(role);
        }
        if (removed == null) {
            return;
        }
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementRemoved(removed, role);
        }
        JpsElementBase.setParent((JpsElement)removed, null);
    }

    protected final Object getDataLock() {
        return this.myDataLock;
    }

    protected final Map<JpsElementChildRole<?>, JpsElement> getElementsMap() {
        return this.myElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges(@NotNull JpsElementContainerEx modified) {
        ArrayList<Object> roles = new ArrayList<Object>();
        Iterator iterator = this.myDataLock;
        synchronized (iterator) {
            roles.addAll(this.myElements.keySet());
        }
        for (JpsElementChildRole jpsElementChildRole : roles) {
            this.applyChanges(jpsElementChildRole, modified);
        }
        roles.clear();
        iterator = modified.getDataLock();
        synchronized (iterator) {
            roles.addAll(modified.getElementsMap().keySet());
        }
        iterator = this.myDataLock;
        synchronized (iterator) {
            roles.removeAll(this.myElements.keySet());
        }
        for (JpsElementChildRole jpsElementChildRole : roles) {
            this.applyChanges(jpsElementChildRole, modified);
        }
    }

    private <T extends JpsElement> void applyChanges(JpsElementChildRole<T> role, JpsElementContainerEx modified) {
        T child = this.getChild(role);
        JpsElement modifiedChild = modified.getChild(role);
        if (child != null && modifiedChild != null) {
            JpsElement.BulkModificationSupport modificationSupport = child.getBulkModificationSupport();
            modificationSupport.applyChanges(modifiedChild);
        } else if (modifiedChild == null) {
            this.removeChild(role);
        } else {
            this.setChild(role, modifiedChild.getBulkModificationSupport().createCopy());
        }
    }

    @Nullable
    private JpsEventDispatcher getEventDispatcher() {
        return this.myParent.getEventDispatcher();
    }
}

