/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.DefaultTerminalRunnerFactory;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowPanel;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabLeftAction;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabRightAction;
import org.jetbrains.plugins.terminal.action.RenameTerminalSessionAction;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public final class TerminalView {
    private static final Key<JBTerminalWidget> TERMINAL_WIDGET_KEY = new Key("TerminalWidget");
    private static final Logger LOG = Logger.getInstance(TerminalView.class);
    private ToolWindow myToolWindow;
    private final Project myProject;
    private final AbstractTerminalRunner<?> myTerminalRunner;
    private TerminalDockContainer myDockContainer;
    private final Map<JBTerminalWidget, TerminalContainer> myContainerByWidgetMap = new HashMap<JBTerminalWidget, TerminalContainer>();

    @NotNull
    public AbstractTerminalRunner<?> getTerminalRunner() {
        return this.myTerminalRunner;
    }

    public TerminalView(@NotNull Project project) {
        this.myProject = project;
        this.myTerminalRunner = ((DefaultTerminalRunnerFactory)ApplicationManager.getApplication().getService(DefaultTerminalRunnerFactory.class)).create(project);
    }

    public static TerminalView getInstance(@NotNull Project project) {
        return (TerminalView)project.getService(TerminalView.class);
    }

    void initToolWindow(final @NotNull ToolWindowEx toolWindow) {
        if (this.myToolWindow != null) {
            LOG.error("Terminal tool window already initialized");
            return;
        }
        this.myToolWindow = toolWindow;
        toolWindow.setTabActions(new AnAction[]{new DumbAwareAction(IdeBundle.messagePointer((String)"action.DumbAware.TerminalView.text.new.session", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.DumbAware.TerminalView.description.create.new.session", (Object[])new Object[0]), AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TerminalView.this.newTab((ToolWindow)toolWindow, null);
            }
        }});
        toolWindow.setTabDoubleClickActions(Collections.singletonList(new RenameTerminalSessionAction()));
        toolWindow.setToHideOnEmptyContent(true);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void toolWindowShown(@NotNull String id, @NotNull ToolWindow toolWindow) {
                if ("Terminal".equals(id) && TerminalView.this.myToolWindow == toolWindow && toolWindow.isVisible() && toolWindow.getContentManager().getContentCount() == 0) {
                    TerminalView.this.createNewSession(TerminalView.this.myTerminalRunner, null, true);
                }
            }
        });
        if (this.myDockContainer == null) {
            this.myDockContainer = new TerminalDockContainer();
            DockManager.getInstance((Project)this.myProject).register((DockContainer)this.myDockContainer, toolWindow.getDisposable());
        }
    }

    void restoreTabs(@Nullable TerminalArrangementState arrangementState) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        if (arrangementState != null) {
            for (TerminalTabState tabState : arrangementState.myTabStates) {
                this.createNewSession(this.myTerminalRunner, tabState, false);
            }
            Content content = contentManager.getContent(arrangementState.mySelectedTabIndex);
            if (content != null) {
                contentManager.setSelectedContent(content);
            }
        }
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner) {
        this.createNewSession(terminalRunner, null);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState) {
        this.createNewSession(terminalRunner, tabState, true);
    }

    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable String tabName) {
        TerminalTabState tabState = new TerminalTabState();
        tabState.myTabName = tabName;
        tabState.myWorkingDirectory = workingDirectory;
        JBTerminalWidget widget = this.createNewSession(this.myTerminalRunner, tabState, true);
        return (ShellTerminalWidget)Objects.requireNonNull(widget);
    }

    @NotNull
    private JBTerminalWidget createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState, boolean requestFocus) {
        ToolWindow toolWindow = this.getOrInitToolWindow();
        Content content = this.createNewTab(null, terminalRunner, toolWindow, tabState, requestFocus);
        return Objects.requireNonNull(TerminalView.getWidgetByContent(content));
    }

    @NotNull
    private ToolWindow getOrInitToolWindow() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal");
            Objects.requireNonNull(toolWindow).getContentManager();
            LOG.assertTrue(toolWindow == this.myToolWindow);
        }
        return toolWindow;
    }

    @NotNull
    private Content newTab(@NotNull ToolWindow toolWindow, @Nullable JBTerminalWidget terminalWidget) {
        return this.createNewTab(terminalWidget, this.myTerminalRunner, toolWindow, null, true);
    }

    @NotNull
    private Content createNewTab(@Nullable JBTerminalWidget terminalWidget, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ToolWindow toolWindow, @Nullable TerminalTabState tabState, boolean requestFocus) {
        Content content = this.createTerminalContent(terminalRunner, toolWindow, terminalWidget, tabState);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent(content);
        new TerminalTabCloseListener(content, this.myProject);
        Runnable selectRunnable = () -> contentManager.setSelectedContent(content, requestFocus);
        if (requestFocus && !toolWindow.isActive()) {
            LOG.info("Activating " + toolWindow.getId() + " tool window");
            toolWindow.activate(selectRunnable, true, true);
        } else {
            selectRunnable.run();
        }
        return content;
    }

    private static String generateUniqueName(String suggestedName, List<String> tabs) {
        HashSet names = Sets.newHashSet(tabs);
        return UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !names.contains(o));
    }

    @NotNull
    private Content createTerminalContent(@NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ToolWindow toolWindow, @Nullable JBTerminalWidget terminalWidget, @Nullable TerminalTabState tabState) {
        TerminalToolWindowPanel panel = new TerminalToolWindowPanel(PropertiesComponent.getInstance((Project)this.myProject), toolWindow);
        String tabName = (String)ObjectUtils.notNull((Object)(tabState != null ? tabState.myTabName : null), (Object)TerminalOptionsProvider.getInstance().getTabName());
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)panel), tabName, false);
        if (terminalWidget == null) {
            VirtualFile currentWorkingDir = TerminalView.getCurrentWorkingDir(tabState);
            terminalWidget = terminalRunner.createTerminalWidget((Disposable)content, currentWorkingDir);
            TerminalArrangementManager.getInstance(this.myProject).register(terminalWidget, tabState);
            TerminalWorkingDirectoryManager.setInitialWorkingDirectory(content, currentWorkingDir);
        } else {
            terminalWidget.setVirtualFile(null);
            terminalWidget.moveDisposable((Disposable)content);
        }
        this.setupTerminalWidget(toolWindow, terminalWidget, tabState, content, true);
        content.setCloseable(true);
        content.putUserData(TERMINAL_WIDGET_KEY, (Object)terminalWidget);
        TerminalContainer container = new TerminalContainer(this.myProject, content, terminalWidget, this);
        panel.setContent(container.getComponent());
        panel.addFocusListener(TerminalView.createFocusListener(toolWindow));
        panel.updateDFState();
        TerminalView.updatePreferredFocusableComponent(content, terminalWidget);
        return content;
    }

    private void setupTerminalWidget(final @NotNull ToolWindow toolWindow, final @NotNull JBTerminalWidget terminalWidget, final @Nullable TerminalTabState tabState, final @NotNull Content content, final boolean updateContentDisplayName) {
        final MoveTerminalToolWindowTabLeftAction moveTabLeftAction = new MoveTerminalToolWindowTabLeftAction();
        final MoveTerminalToolWindowTabRightAction moveTabRightAction = new MoveTerminalToolWindowTabRightAction();
        terminalWidget.setListener(new JBTerminalWidgetListener(){

            public void onNewSession() {
                TerminalView.this.newTab(toolWindow, null);
            }

            public void onTerminalStarted() {
                if (updateContentDisplayName && (tabState == null || StringUtil.isEmpty((String)tabState.myTabName))) {
                    String name = terminalWidget.getSettingsProvider().tabName(terminalWidget.getTtyConnector(), terminalWidget.getSessionName());
                    ArrayList contents = ContainerUtil.newArrayList((Object[])toolWindow.getContentManager().getContents());
                    contents.remove(content);
                    content.setDisplayName(TerminalView.generateUniqueName(name, ContainerUtil.map((Collection)contents, c -> c.getDisplayName())));
                }
            }

            public void onPreviousTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectPreviousContent();
                }
            }

            public void onNextTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectNextContent();
                }
            }

            public void onSessionClosed() {
                terminalWidget.close();
            }

            public void showTabs() {
                ShowContentAction action = new ShowContentAction(toolWindow, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)toolWindow.getComponent());
                KeyEvent fakeKeyEvent = new KeyEvent(toolWindow.getComponent(), 1001, System.currentTimeMillis(), 0, 0, '\u0000');
                AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)fakeKeyEvent, (String)"unknown", null, (DataContext)dataContext);
                action.actionPerformed(event);
            }

            public void moveTabRight() {
                moveTabRightAction.move(content, TerminalView.this.myProject);
            }

            public void moveTabLeft() {
                moveTabLeftAction.move(content, TerminalView.this.myProject);
            }

            public boolean canMoveTabRight() {
                return moveTabRightAction.isAvailable(content);
            }

            public boolean canMoveTabLeft() {
                return moveTabLeftAction.isAvailable(content);
            }

            public boolean canSplit(boolean vertically) {
                return true;
            }

            public void split(boolean vertically) {
                TerminalView.this.split(terminalWidget, vertically);
            }

            public boolean isGotoNextSplitTerminalAvailable() {
                return TerminalView.this.isSplitTerminal(terminalWidget);
            }

            public void gotoNextSplitTerminal(boolean forward) {
                TerminalView.this.gotoNextSplitTerminal(terminalWidget, forward);
            }
        });
        terminalWidget.getTerminalPanel().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TerminalView.updatePreferredFocusableComponent(content, terminalWidget);
            }
        });
    }

    private static void updatePreferredFocusableComponent(@NotNull Content content, @NotNull JBTerminalWidget terminalWidget) {
        content.setPreferredFocusableComponent(terminalWidget.getPreferredFocusableComponent());
    }

    public boolean isSplitTerminal(@NotNull JBTerminalWidget widget) {
        TerminalContainer container = Objects.requireNonNull(this.myContainerByWidgetMap.get(widget));
        return container.isSplitTerminal();
    }

    public void gotoNextSplitTerminal(@NotNull JBTerminalWidget widget, boolean forward) {
        TerminalContainer container = Objects.requireNonNull(this.myContainerByWidgetMap.get(widget));
        JBTerminalWidget next = container.getNextSplitTerminal(forward);
        if (next != null) {
            container.requestFocus(next);
        }
    }

    public void split(@NotNull JBTerminalWidget widget, boolean vertically) {
        TerminalContainer container = Objects.requireNonNull(this.myContainerByWidgetMap.get(widget));
        JBTerminalWidget newWidget = this.myTerminalRunner.createTerminalWidget((Disposable)container.getContent(), null);
        this.setupTerminalWidget(this.myToolWindow, newWidget, null, container.getContent(), false);
        container.split(!vertically, newWidget);
    }

    public void register(@NotNull TerminalContainer terminalContainer) {
        this.myContainerByWidgetMap.put(terminalContainer.getTerminalWidget(), terminalContainer);
    }

    public void unregister(@NotNull TerminalContainer terminalContainer) {
        this.myContainerByWidgetMap.remove(terminalContainer.getTerminalWidget());
        if (TerminalView.getWidgetByContent(terminalContainer.getContent()) == terminalContainer.getTerminalWidget()) {
            terminalContainer.getContent().putUserData(TERMINAL_WIDGET_KEY, (Object)this.findWidgetForContent(terminalContainer.getContent()));
        }
    }

    @Nullable
    private JBTerminalWidget findWidgetForContent(@NotNull Content content) {
        JBTerminalWidget any = null;
        for (Map.Entry<JBTerminalWidget, TerminalContainer> entry : this.myContainerByWidgetMap.entrySet()) {
            JBTerminalWidget terminalWidget;
            if (entry.getValue().getContent() != content) continue;
            any = terminalWidget = entry.getKey();
            if (!terminalWidget.getTerminalPanel().hasFocus()) continue;
            return terminalWidget;
        }
        return any;
    }

    @NotNull
    public TerminalContainer getContainer(@NotNull JBTerminalWidget terminalWidget) {
        return Objects.requireNonNull(this.myContainerByWidgetMap.get(terminalWidget));
    }

    @Nullable
    private static VirtualFile getCurrentWorkingDir(@Nullable TerminalTabState tabState) {
        String dir = tabState != null ? tabState.myWorkingDirectory : null;
        VirtualFile result = null;
        if (dir != null) {
            result = LocalFileSystem.getInstance().findFileByPath(dir);
        }
        return result;
    }

    public void closeTab(@NotNull Content content) {
        this.myToolWindow.getContentManager().removeContent(content, true, true, true);
    }

    @NotNull
    private static FocusListener createFocusListener(final @NotNull ToolWindow toolWindow) {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component = TerminalView.getComponentToFocus(toolWindow);
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    @Nullable
    private static JComponent getComponentToFocus(@NotNull ToolWindow toolWindow) {
        Content selectedContent = toolWindow.getContentManager().getSelectedContent();
        if (selectedContent != null) {
            return selectedContent.getPreferredFocusableComponent();
        }
        return toolWindow.getComponent();
    }

    public void openTerminalIn(@Nullable VirtualFile fileToOpen) {
        TerminalTabState state = new TerminalTabState();
        if (fileToOpen != null) {
            state.myWorkingDirectory = fileToOpen.getPath();
        }
        this.createNewSession(this.myTerminalRunner, state);
    }

    @Nullable
    public static JBTerminalWidget getWidgetByContent(@NotNull Content content) {
        return (JBTerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY);
    }

    public void detachWidgetAndRemoveContent(@NotNull Content content) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        LOG.assertTrue(contentManager.getIndexOfContent(content) >= 0, (Object)"Not a terminal content");
        contentManager.removeContent(content, true);
        content.putUserData(TERMINAL_WIDGET_KEY, null);
    }

    private final class TerminalDockContainer
    implements DockContainer {
        private TerminalDockContainer() {
        }

        @NotNull
        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(TerminalView.this.myToolWindow.getComponent());
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
            return this.isTerminalSessionContent(content) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        }

        public JComponent getContainerComponent() {
            return TerminalView.this.myToolWindow.getComponent();
        }

        public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
            if (this.isTerminalSessionContent(content)) {
                TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)((Object)content.getKey());
                String name = terminalFile.getName();
                Content newContent = TerminalView.this.newTab(TerminalView.this.myToolWindow, terminalFile.getTerminalWidget());
                newContent.setDisplayName(name);
            }
        }

        private boolean isTerminalSessionContent(@NotNull DockableContent<?> content) {
            return content.getKey() instanceof TerminalSessionVirtualFileImpl;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }
    }
}

