/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalShellCommandHandlerHelper;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.TerminalUtil;

public class ShellTerminalWidget
extends JBTerminalWidget {
    private static final Logger LOG = Logger.getInstance(ShellTerminalWidget.class);
    private final Project myProject;
    private boolean myEscapePressed = false;
    private String myCommandHistoryFilePath;
    private boolean myPromptUpdateNeeded = true;
    private String myPrompt = "";
    private final Queue<String> myPendingCommandsToExecute = new LinkedList<String>();
    private final TerminalShellCommandHandlerHelper myShellCommandHandlerHelper;

    public ShellTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull Disposable parent) {
        super(project, settingsProvider, parent);
        this.myProject = project;
        this.myShellCommandHandlerHelper = new TerminalShellCommandHandlerHelper(this);
        ((JBTerminalPanel)this.getTerminalPanel()).addPreKeyEventHandler(e -> {
            if (e.getID() != 401) {
                return;
            }
            if (e.getKeyCode() == 27) {
                this.myEscapePressed = true;
            }
            if (this.myPromptUpdateNeeded) {
                this.myPrompt = this.getLineAtCursor();
                if (LOG.isDebugEnabled()) {
                    LOG.info("Guessed shell prompt: " + this.myPrompt);
                }
                this.myPromptUpdateNeeded = false;
            }
            if (e.getKeyCode() == 10 || TerminalShellCommandHandlerHelper.matchedExecutor(e) != null) {
                TerminalUsageTriggerCollector.Companion.triggerCommandExecuted(this.myProject);
                if (this.myShellCommandHandlerHelper.processEnterKeyPressed((KeyEvent)e)) {
                    e.consume();
                }
                if (!e.isConsumed()) {
                    this.myPromptUpdateNeeded = true;
                    this.myEscapePressed = false;
                }
            } else {
                this.myShellCommandHandlerHelper.processKeyPressed();
            }
        });
    }

    @NotNull
    Project getProject() {
        return this.myProject;
    }

    public void setCommandHistoryFilePath(@Nullable String commandHistoryFilePath) {
        this.myCommandHistoryFilePath = commandHistoryFilePath;
    }

    @Nullable
    public static String getCommandHistoryFilePath(@Nullable JBTerminalWidget terminalWidget) {
        return terminalWidget instanceof ShellTerminalWidget ? ((ShellTerminalWidget)terminalWidget).myCommandHistoryFilePath : null;
    }

    @NotNull
    public String getTypedShellCommand() {
        if (this.myPromptUpdateNeeded) {
            return "";
        }
        String line = this.getLineAtCursor();
        return StringUtil.trimStart((String)line, (String)this.myPrompt);
    }

    @NotNull
    private String getLineAtCursor() {
        return this.processTerminalBuffer(textBuffer -> {
            TerminalLine line = textBuffer.getLine(this.getLineNumberAtCursor());
            return line != null ? line.getText() : "";
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T processTerminalBuffer(@NotNull Function<TerminalTextBuffer, T> processor) {
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        textBuffer.lock();
        try {
            T t = processor.apply(textBuffer);
            return t;
        }
        finally {
            textBuffer.unlock();
        }
    }

    int getLineNumberAtCursor() {
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        Terminal terminal = this.getTerminal();
        return Math.max(0, Math.min(terminal.getCursorY() - 1, textBuffer.getHeight() - 1));
    }

    public void executeCommand(@NotNull String shellCommand) throws IOException {
        String typedCommand = this.getTypedShellCommand();
        if (!typedCommand.isEmpty()) {
            throw new IOException("Cannot execute command when another command is typed: " + typedCommand);
        }
        TtyConnector connector = this.getTtyConnector();
        if (connector != null) {
            this.doExecuteCommand(shellCommand, connector);
        } else {
            this.myPendingCommandsToExecute.add(shellCommand);
        }
    }

    public void setTtyConnector(@NotNull TtyConnector ttyConnector) {
        String command;
        super.setTtyConnector(ttyConnector);
        while ((command = this.myPendingCommandsToExecute.poll()) != null) {
            try {
                this.doExecuteCommand(command, ttyConnector);
            }
            catch (IOException e) {
                LOG.warn("Cannot execute " + command, (Throwable)e);
            }
        }
    }

    private void doExecuteCommand(@NotNull String shellCommand, @NotNull TtyConnector connector) throws IOException {
        StringBuilder result = new StringBuilder();
        if (this.myEscapePressed) {
            result.append('\b');
        }
        String enterCode = new String(this.getTerminalStarter().getCode(10, 0), StandardCharsets.UTF_8);
        result.append(shellCommand).append(enterCode);
        connector.write(result.toString());
    }

    public boolean hasRunningCommands() throws IllegalStateException {
        TtyConnector connector = this.getTtyConnector();
        if (connector == null) {
            return false;
        }
        if (connector instanceof ProcessTtyConnector) {
            return TerminalUtil.hasRunningCommands((ProcessTtyConnector)connector);
        }
        throw new IllegalStateException("Cannot determine if there are running processes for " + connector.getClass());
    }
}

