/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.ProgressReporterImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItemKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.FilesToRecompile;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.IdeaPlatformKt;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinCompileContextKt;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.MessageCollectorAdapter;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageManager;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 G2\u00020\u0001:\u0001GB\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016JT\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0016\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002JD\u0010#\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0002J^\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u00020\u00172\u0016\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0010\u00100\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00103\u001a\u0012\u0012\u0004\u0012\u00020504j\b\u0012\u0004\u0012\u000205`6H\u0016J2\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000209080\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u000205H\u0016J\u0010\u0010=\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010>\u001a\u00020\u00122\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010@\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010A\u001a\u000202H\u0002JJ\u0010B\u001a\u00020\u00122\u0018\u0010C\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000209080\u001b2\u0006\u0010A\u001a\u0002022\u0016\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010'\u001a\u00020(H\u0002J \u0010D\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u000b\u001a\u00020&H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "buildFinished", "", "buildStarted", "chunkBuildFinished", "chunkBuildStarted", "createCompileEnvironment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "kotlinModuleBuilderTarget", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/MessageCollectorAdapter;", "doBuild", "representativeTarget", "kotlinDirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "kotlinChunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "ensureKotlinContextDisposed", "ensureKotlinContextInitialized", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "outputItemCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "getPresentableName", "initializeKotlinContext", "loadPlugins", "logSettings", "markAdditionalFilesForInitialRound", "kotlinContext", "markDirtyComplementaryMultifileClasses", "generatedFiles", "updateLookupStorage", "lookupStorageManager", "Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "Companion", "kotlin.jps-plugin"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String SKIP_CACHE_VERSION_CHECK_PROPERTY = "kotlin.jps.skip.cache.version.check";
    @NotNull
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getPresentableName() {
        return KOTLIN_BUILDER_NAME;
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return CollectionsKt.arrayListOf((Object[])new String[]{"kt", "kts"});
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logSettings(context);
    }

    private final void logSettings(CompileContext context) {
        LOG.debug("==========================================");
        LOG.info("is Kotlin incremental compilation enabled for JVM: " + IncrementalCompilation.isEnabledForJvm());
        LOG.info("is Kotlin incremental compilation enabled for JS: " + IncrementalCompilation.isEnabledForJs());
        LOG.info("is Kotlin compiler daemon enabled: " + DaemonParamsKt.isDaemonEnabled());
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            LOG.info("Label in local history: " + historyLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final KotlinCompileContext ensureKotlinContextInitialized(CompileContext context) {
        KotlinCompileContext kotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
        if (kotlinCompileContext != null) {
            return kotlinCompileContext;
        }
        GlobalContextKey<KotlinCompileContext> globalContextKey = KotlinCompileContextKt.getKotlinCompileContextKey();
        boolean bl = false;
        boolean bl2 = false;
        synchronized (globalContextKey) {
            boolean bl3 = false;
            KotlinCompileContext actualKotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
            if (actualKotlinCompileContext != null) {
                return actualKotlinCompileContext;
            }
            try {
                return this.initializeKotlinContext(context);
            }
            catch (Throwable t) {
                IdeaPlatformKt.jpsReportInternalBuilderError(context, new Error("Cannot initialize Kotlin context: " + t.getMessage(), t));
                throw t;
            }
        }
    }

    private final KotlinCompileContext initializeKotlinContext(CompileContext context) {
        KotlinCompileContext kotlinContext2 = null;
        boolean $i$f$measureTimeMillis = false;
        boolean bl = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        kotlinContext2 = new KotlinCompileContext(context);
        context.putUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey(), (Object)kotlinContext2);
        TestingContext testingContext = TestingContextKt.getTestingContext(context);
        if (testingContext != null) {
            testingContext.setKotlinCompileContext(kotlinContext2);
        }
        if (kotlinContext2.getShouldCheckCacheVersions() && kotlinContext2.hasKotlin()) {
            kotlinContext2.checkCacheVersions();
        }
        kotlinContext2.cleanupCaches();
        kotlinContext2.reportUnsupportedTargets();
        long time = System.currentTimeMillis() - start$iv;
        LOG.info("Total Kotlin global compile context initialization time: " + time + " ms");
        return kotlinContext2;
    }

    public void buildFinished(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureKotlinContextDisposed(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureKotlinContextDisposed(CompileContext context) {
        if (context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey()) != null) {
            GlobalContextKey<KotlinCompileContext> globalContextKey = KotlinCompileContextKt.getKotlinCompileContextKey();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (globalContextKey) {
                boolean bl3 = false;
                KotlinCompileContext kotlinCompileContext = (KotlinCompileContext)context.getUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey());
                if (kotlinCompileContext != null) {
                    kotlinCompileContext.dispose();
                    context.putUserData((Key)KotlinCompileContextKt.getKotlinCompileContextKey(), null);
                    this.statisticsLogger.reportTotal();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        block10: {
            boolean bl;
            TestingBuildLogger buildLogger;
            KotlinCompileContext kotlinContext2;
            block9: {
                Set targets;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                super.chunkBuildStarted(context, chunk);
                if (JpsUtilKt.isDummy(chunk, context)) {
                    return;
                }
                kotlinContext2 = this.ensureKotlinContextInitialized(context);
                TestingContext testingContext = TestingContextKt.getTestingContext(context);
                TestingBuildLogger testingBuildLogger = buildLogger = testingContext != null ? testingContext.getBuildLogger() : null;
                if (testingBuildLogger != null) {
                    testingBuildLogger.chunkBuildStarted(context, chunk);
                }
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
                    return;
                }
                Set set = targets = chunk.getTargets();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"targets");
                Iterable $this$none$iv = set;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                        boolean bl2 = false;
                        HasKotlinMarker hasKotlinMarker = kotlinContext2.getHasKotlinMarker();
                        ModuleBuildTarget moduleBuildTarget = it;
                        Intrinsics.checkNotNullExpressionValue((Object)moduleBuildTarget, (String)"it");
                        if (!Intrinsics.areEqual((Object)hasKotlinMarker.get(moduleBuildTarget), (Object)true)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            KotlinChunk kotlinChunk = kotlinContext2.getChunk(chunk);
            if (kotlinChunk == null) {
                return;
            }
            KotlinChunk kotlinChunk2 = kotlinChunk;
            kotlinContext2.checkChunkCacheVersion(kotlinChunk2);
            if (!kotlinContext2.getRebuildingAllKotlin() && kotlinChunk2.isEnabled()) {
                this.markAdditionalFilesForInitialRound(kotlinChunk2, chunk, kotlinContext2);
            }
            TestingBuildLogger testingBuildLogger = buildLogger;
            if (testingBuildLogger == null) break block10;
            testingBuildLogger.afterChunkBuildStarted(context, chunk);
        }
    }

    private final void markAdditionalFilesForInitialRound(KotlinChunk kotlinChunk, ModuleChunk chunk, KotlinCompileContext kotlinContext2) {
        CompileContext context = kotlinContext2.getJpsContext();
        KotlinDirtySourceFilesHolder dirtyFilesHolder2 = new KotlinDirtySourceFilesHolder(chunk, context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)((DirtyFilesHolder)new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context, chunk, context){
            final /* synthetic */ CompileContext $context;
            final /* synthetic */ ModuleChunk $chunk;

            public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) {
                Intrinsics.checkNotNullParameter(processor, (String)"processor");
                FSOperations.processFilesToRecompile((CompileContext)this.$context, (ModuleChunk)this.$chunk, processor);
            }
            {
                this.$context = $captured_local_variable$0;
                this.$chunk = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }));
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, dirtyFilesHolder2, LOG);
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = kotlinContext2.getTargetsBinding().get(chunk.representativeTarget());
        if (kotlinModuleBuildTarget == null) {
            return;
        }
        KotlinModuleBuildTarget<?> representativeTarget = kotlinModuleBuildTarget;
        Map<KotlinModuleBuildTarget<?>, JpsIncrementalCache> incrementalCaches = kotlinChunk.loadCaches(false);
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context, representativeTarget);
        JpsCompilerEnvironment environment = this.createCompileEnvironment(kotlinContext2.getJpsContext(), representativeTarget, incrementalCaches, LookupTracker.DO_NOTHING.INSTANCE, ExpectActualTracker.DoNothing.INSTANCE, chunk, messageCollector);
        HashSet<String> removedClasses = new HashSet<String>();
        for (KotlinModuleBuildTarget<?> target : kotlinChunk.getTargets()) {
            JpsIncrementalCache cache;
            if (incrementalCaches.get(target) == null) {
                continue;
            }
            Set<File> dirtyFiles = dirtyFilesHolder2.getDirtyFiles(target.getJpsModuleBuildTarget()).keySet();
            Collection<File> removedFiles = dirtyFilesHolder2.getRemovedFiles(target.getJpsModuleBuildTarget());
            Set<String> existingClasses = new JpsKotlinCompilerRunner().classesFqNamesByFiles(environment, dirtyFiles);
            Collection<FqName> previousClasses = cache.classesFqNamesBySources(SetsKt.plus(dirtyFiles, (Iterable)removedFiles));
            for (FqName jvmClassName : previousClasses) {
                String fqName2;
                Intrinsics.checkNotNullExpressionValue((Object)jvmClassName.asString(), (String)"jvmClassName.asString()");
                if (existingClasses.contains(fqName2)) continue;
                removedClasses.add(fqName2);
            }
        }
        ChangesCollector changesCollector = new ChangesCollector();
        Iterable $this$forEach$iv = removedClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            changesCollector.collectSignature(new FqName(it), true);
        }
        FilesToRecompile affectedByRemovedClasses = KotlinBuilderKt.access$getDirtyFiles(changesCollector, incrementalCaches.values(), kotlinContext2.getLookupStorageManager());
        fsOperations.markFilesForCurrentRound$kotlin_jps_plugin(SetsKt.plus(affectedByRemovedClasses.getDirtyFiles(), (Iterable)affectedByRemovedClasses.getForceRecompileTogether()));
    }

    public void chunkBuildFinished(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        super.chunkBuildFinished(context, chunk);
        if (JpsUtilKt.isDummy(chunk, context)) {
            return;
        }
        KotlinCompileContext kotlinContext2 = this.ensureKotlinContextInitialized(context);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            Collection outputRoots;
            HasKotlinMarker hasKotlinMarker = kotlinContext2.getHasKotlinMarker();
            ModuleBuildTarget moduleBuildTarget = target;
            Intrinsics.checkNotNullExpressionValue((Object)moduleBuildTarget, (String)"target");
            if (Intrinsics.areEqual((Object)hasKotlinMarker.get(moduleBuildTarget), (Object)true) ^ true) continue;
            Intrinsics.checkNotNullExpressionValue((Object)target.getOutputRoots(context), (String)"target.getOutputRoots(context)");
            if (outputRoots.size() <= 1) continue;
            Iterable $this$forEach$iv = outputRoots;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                it.mkdirs();
            }
        }
        LOG.debug("------------------------------------------");
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        boolean bl;
        MessageCollectorAdapter messageCollector;
        KotlinModuleBuildTarget<?> kotlinTarget;
        block12: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Intrinsics.checkNotNullParameter(dirtyFilesHolder2, (String)"dirtyFilesHolder");
            Intrinsics.checkNotNullParameter((Object)outputConsumer, (String)"outputConsumer");
            if (JpsUtilKt.isDummy(chunk, context)) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = KotlinCompileContextKt.getKotlin(context).getTargetsBinding().get(chunk.representativeTarget());
            if (kotlinModuleBuildTarget == null) {
                return ModuleLevelBuilder.ExitCode.OK;
            }
            kotlinTarget = kotlinModuleBuildTarget;
            messageCollector = new MessageCollectorAdapter(context, kotlinTarget);
            Set set = chunk.getModules();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"chunk.modules");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JpsModule it = (JpsModule)element$iv;
                    boolean bl2 = false;
                    JpsModule jpsModule = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"it");
                    if (!(ModuleSettingsKt.getKotlinKind(jpsModule) == KotlinModuleKind.SOURCE_SET_HOLDER)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            if (chunk.getModules().size() > 1) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cyclically dependent modules are not supported in multiplatform projects", null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder = new KotlinDirtySourceFilesHolder(chunk, context, dirtyFilesHolder2);
        FSOperationsHelper fsOperations = new FSOperationsHelper(context, chunk, kotlinDirtyFilesHolder, LOG);
        try {
            ModuleLevelBuilder.ExitCode proposedExitCode = this.doBuild(chunk, kotlinTarget, context, kotlinDirtyFilesHolder, messageCollector, outputConsumer, fsOperations);
            ModuleLevelBuilder.ExitCode actualExitCode = proposedExitCode == ModuleLevelBuilder.ExitCode.OK && fsOperations.getHasMarkedDirty$kotlin_jps_plugin() ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : proposedExitCode;
            LOG.debug("Build result: " + actualExitCode);
            Object object = TestingContextKt.getTestingContext(context);
            if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                object.buildFinished(actualExitCode);
            }
            return actualExitCode;
        }
        catch (StopBuildException e) {
            LOG.info("Caught exception: " + (Object)((Object)e));
            throw (Throwable)e;
        }
        catch (BuildDataCorruptedException e) {
            LOG.info("Caught exception: " + (Object)((Object)e));
            throw (Throwable)e;
        }
        catch (Throwable e) {
            LOG.info("Caught exception: " + e);
            MessageCollectorUtil.reportException(messageCollector, e);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, KotlinModuleBuildTarget<?> representativeTarget, CompileContext context, KotlinDirtySourceFilesHolder kotlinDirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer, FSOperationsHelper fsOperations) {
        block36: {
            block35: {
                if (representativeTarget instanceof KotlinJvmModuleBuildTarget && !((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", null, 4, null);
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                kotlinContext = KotlinCompileContextKt.getKotlin(context);
                v0 = JpsUtilKt.toKotlinChunk(chunk, context);
                Intrinsics.checkNotNull((Object)v0);
                kotlinChunk = v0;
                if (!kotlinChunk.getHaveSameCompiler()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cyclically dependent modules " + kotlinChunk.getPresentableModulesToCompilersList() + " should have same compiler.", null, 4, null);
                    return ModuleLevelBuilder.ExitCode.ABORT;
                }
                if (!kotlinChunk.isEnabled()) {
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                projectDescriptor = context.getProjectDescriptor();
                targets = chunk.getTargets();
                if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) ** GOTO lbl-1000
                v1 = targets;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"targets");
                $this$any$iv = v1;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Iterable element$iv : $this$any$iv) {
                        it = (ModuleBuildTarget)element$iv /* !! */ ;
                        $i$a$-any-KotlinBuilder$doBuild$isChunkRebuilding$1 = false;
                        v3 = kotlinContext.getRebuildAfterCacheVersionChanged();
                        v4 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                        if (!Intrinsics.areEqual((Object)v3.get(v4), (Object)true)) continue;
                        v2 = true;
                        break block35;
                    }
                    v2 = false;
                }
            }
            if (v2) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = isChunkRebuilding = false;
            }
            if (!kotlinDirtyFilesHolder.getHasDirtyOrRemovedFiles()) {
                if (isChunkRebuilding) {
                    v6 = targets;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"targets");
                    $this$forEach$iv = v6;
                    $i$f$forEach = false;
                    for (Iterable element$iv : $this$forEach$iv) {
                        it = (ModuleBuildTarget)element$iv /* !! */ ;
                        $i$a$-forEach-KotlinBuilder$doBuild$1 = false;
                        v7 = kotlinContext.getHasKotlinMarker();
                        v8 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it");
                        v7.set(v8, false);
                    }
                }
                v9 = targets;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"targets");
                $this$forEach$iv = v9;
                $i$f$forEach = false;
                for (Iterable element$iv : $this$forEach$iv) {
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    $i$a$-forEach-KotlinBuilder$doBuild$2 = false;
                    v10 = kotlinContext.getRebuildAfterCacheVersionChanged();
                    v11 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"it");
                    v10.clean(v11);
                }
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            if (!isChunkRebuilding && !representativeTarget.isIncrementalCompilationEnabled()) {
                v12 = targets;
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"targets");
                $this$forEach$iv = v12;
                $i$f$forEach = false;
                for (Iterable element$iv : $this$forEach$iv) {
                    it = (ModuleBuildTarget)element$iv /* !! */ ;
                    $i$a$-forEach-KotlinBuilder$doBuild$3 = false;
                    v13 = kotlinContext.getRebuildAfterCacheVersionChanged();
                    v14 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"it");
                    v13.set(v14, true);
                }
                return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
            }
            v15 = targets;
            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"targets");
            $this$filter$iv = v15;
            $i$f$filter = false;
            element$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (ModuleBuildTarget)element$iv$iv;
                $i$a$-filter-KotlinBuilder$doBuild$targetsWithoutOutputDir$1 = false;
                v16 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"it");
                if (!(v16.getOutputDir() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            targetsWithoutOutputDir = (List)destination$iv$iv;
            $this$filter$iv = targetsWithoutOutputDir;
            $i$f$filter = false;
            if ($this$filter$iv.isEmpty() == false) {
                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Output directory not specified for " + CollectionsKt.joinToString$default((Iterable)targetsWithoutOutputDir, null, null, null, (int)0, null, null, (int)63, null), null, 4, null);
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            v17 = projectDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"projectDescriptor");
            v18 = project = v17.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"project");
            lookupTracker = KotlinBuilderKt.access$getLookupTracker(v18, representativeTarget);
            exceptActualTracer = new ExpectActualTrackerImpl();
            incrementalCaches = KotlinChunk.loadCaches$default(kotlinChunk, false, 1, null);
            environment = this.createCompileEnvironment(context, representativeTarget, incrementalCaches, lookupTracker, exceptActualTracer, chunk, messageCollector);
            v19 = TestingContextKt.getTestingContext(context);
            if (v19 != null && (v19 = v19.getBuildLogger()) != null) {
                v19.compilingFiles((Collection<? extends File>)kotlinDirtyFilesHolder.getAllDirtyFiles(), (Collection<? extends File>)kotlinDirtyFilesHolder.getAllRemovedFilesFiles());
                v20 = Unit.INSTANCE;
            } else {
                v20 = null;
            }
            if (KotlinBuilder.LOG.isDebugEnabled()) {
                KotlinBuilder.LOG.debug("Compiling files: " + kotlinDirtyFilesHolder.getAllDirtyFiles());
            }
            start = System.nanoTime();
            outputItemCollector = this.doCompileModuleChunk(kotlinChunk, representativeTarget, kotlinChunk.getCompilerArguments(), context, kotlinDirtyFilesHolder, fsOperations, environment, incrementalCaches);
            this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
            if (outputItemCollector == null) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            v21 = compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"compilationErrors");
            if (v21.booleanValue()) {
                KotlinBuilder.LOG.info("Compiled with errors");
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            KotlinBuilder.LOG.info("Compiled successfully");
            generatedFiles = this.getGeneratedFiles(context, chunk, environment.getOutputItemsCollector());
            this.markDirtyComplementaryMultifileClasses((Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>>)generatedFiles, kotlinContext, incrementalCaches, fsOperations);
            kotlinTargets = kotlinContext.getTargetsBinding();
            var27_31 = generatedFiles;
            var28_32 = false;
            var26_36 = var27_31.entrySet().iterator();
            while (var26_36.hasNext()) {
                var29_41 = var25_40 = var26_36.next();
                var30_42 = false;
                var27_31 = var29_41.getKey();
                var29_41 = var25_40;
                var30_42 = false;
                outputItems = var29_41.getValue();
                if (kotlinTargets.get(target) == null) {
                    var30_43 = "Could not find Kotlin target for JPS target " + target;
                    var31_45 = false;
                    throw (Throwable)new IllegalStateException(var30_43.toString());
                }
                kotlinTarget.registerOutputItems(outputConsumer, outputItems);
            }
            kotlinChunk.saveVersions();
            $this$any$iv = targets;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v22 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (ModuleBuildTarget)element$iv;
                    $i$a$-any-KotlinBuilder$doBuild$4 = false;
                    v23 = kotlinContext.getHasKotlinMarker();
                    v24 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"it");
                    if (!(v23.get(v24) == null)) continue;
                    v22 = true;
                    break block36;
                }
                v22 = false;
            }
        }
        if (v22) {
            fsOperations.markChunk(false, true, kotlinDirtyFilesHolder.getAllDirtyFiles());
        }
        for (ModuleBuildTarget target : targets) {
            v25 = kotlinContext.getHasKotlinMarker();
            v26 = target;
            Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"target");
            v25.set(v26, true);
            kotlinContext.getRebuildAfterCacheVersionChanged().clean(target);
        }
        $this$forEach$iv = kotlinChunk.getTargets();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (KotlinModuleBuildTarget)element$iv;
            $i$a$-forEach-KotlinBuilder$doBuild$5 = false;
            it.doAfterBuild();
        }
        representativeTarget.updateChunkMappings(context, chunk, kotlinDirtyFilesHolder, (Map<ModuleBuildTarget, Iterable<GeneratedFile>>)generatedFiles, incrementalCaches);
        if (!representativeTarget.isIncrementalCompilationEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        context.checkCanceled();
        $this$withProgressReporter$iv = environment;
        $i$f$withProgressReporter = false;
        try {
            progress = $this$withProgressReporter$iv.getProgressReporter();
            $i$a$-withProgressReporter-KotlinBuilder$doBuild$6 = false;
            progress.progress("performing incremental compilation analysis");
            changesCollector = new ChangesCollector();
            $i$a$-forEach-KotlinBuilder$doBuild$5 = generatedFiles;
            var31_46 = false;
            var32_49 = $i$a$-forEach-KotlinBuilder$doBuild$5.entrySet().iterator();
            while (var32_49.hasNext()) {
                var34_51 = var33_50 = var32_49.next();
                var35_52 = false;
                $i$a$-forEach-KotlinBuilder$doBuild$5 = (ModuleBuildTarget)var34_51.getKey();
                var34_51 = var33_50;
                var35_52 = false;
                files = (List)var34_51.getValue();
                Intrinsics.checkNotNull(kotlinContext.getTargetsBinding().get(target));
                v27 = incrementalCaches.get(kotlinModuleBuilderTarget);
                Intrinsics.checkNotNull(v27);
                kotlinModuleBuilderTarget.updateCaches(kotlinDirtyFilesHolder, (JpsIncrementalCache)v27, files, changesCollector, environment);
            }
            this.updateLookupStorage(lookupTracker, kotlinContext.getLookupStorageManager(), kotlinDirtyFilesHolder);
            if (!isChunkRebuilding) {
                KotlinBuilderKt.access$processChangesUsingLookups(changesCollector, kotlinDirtyFilesHolder.getAllDirtyFiles(), kotlinContext.getLookupStorageManager(), fsOperations, incrementalCaches.values());
            }
            var36_53 = Unit.INSTANCE;
        }
        finally {
            $this$withProgressReporter$iv.getProgressReporter().clearProgress();
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollector doCompileModuleChunk(KotlinChunk kotlinChunk, KotlinModuleBuildTarget<?> representativeTarget, CommonCompilerArguments commonArguments, CompileContext context, KotlinDirtySourceFilesHolder dirtyFilesHolder2, FSOperationsHelper fsOperations, JpsCompilerEnvironment environment, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches) {
        boolean isDoneSomething;
        this.loadPlugins(representativeTarget, commonArguments, context);
        Iterable $this$forEach$iv = kotlinChunk.getTargets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            it.nextRound(context);
        }
        if (representativeTarget.isIncrementalCompilationEnabled()) {
            for (KotlinModuleBuildTarget<?> target : kotlinChunk.getTargets()) {
                JpsIncrementalCache cache = incrementalCaches.get(target);
                ModuleBuildTarget jpsTarget = target.getJpsModuleBuildTarget();
                KotlinDirtySourceFilesHolder.TargetFiles targetDirtyFiles2 = dirtyFilesHolder2.getByTarget().get(jpsTarget);
                if (cache == null || targetDirtyFiles2 == null) continue;
                Set dirtyFiles = SetsKt.plus(targetDirtyFiles2.getDirty().keySet(), (Iterable)targetDirtyFiles2.getRemoved());
                Collection<File> complementaryFiles = cache.getComplementaryFilesRecursive(dirtyFiles);
                Collection dirtyMultifileClassFiles = CollectionsKt.emptyList();
                if (cache instanceof IncrementalJvmCache) {
                    Iterable list$iv$iv;
                    Iterable $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv;
                    Object it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable<JvmClassName> iterable = ((IncrementalJvmCache)((Object)cache)).classesBySources(dirtyFiles);
                    boolean $i$f$filter = false;
                    void var19_22 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (JvmClassName)element$iv$iv;
                        boolean bl = false;
                        if (!((IncrementalJvmCache)((Object)cache)).isMultifileFacade((JvmClassName)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$flatMap = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (JvmClassName)element$iv$iv;
                        boolean bl = false;
                        Collection collection = ((IncrementalJvmCache)((Object)cache)).getAllPartsOfMultifileFacade((JvmClassName)it);
                        boolean bl2 = false;
                        Collection collection2 = collection;
                        if (collection2 == null) {
                            collection2 = CollectionsKt.emptyList();
                        }
                        list$iv$iv = collection2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    $i$f$flatMap = false;
                    $this$flatMapTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (String)element$iv$iv;
                        boolean bl = false;
                        list$iv$iv = ((IncrementalJvmCache)((Object)cache)).sourcesByInternalName((String)it);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                    $i$f$filter = false;
                    $this$flatMapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (File)element$iv$iv;
                        boolean bl = false;
                        if (!(!dirtyFiles.contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    dirtyMultifileClassFiles = (List)destination$iv$iv;
                }
                fsOperations.markFilesForCurrentRound(jpsTarget, CollectionsKt.plus(complementaryFiles, (Iterable)dirtyMultifileClassFiles));
                cache.markDirty(SetsKt.plus(targetDirtyFiles2.getDirty().keySet(), (Iterable)targetDirtyFiles2.getRemoved()));
            }
        }
        return (isDoneSomething = representativeTarget.compileModuleChunk(commonArguments, dirtyFilesHolder2, environment)) ? (OutputItemsCollector)environment.getOutputItemsCollector() : null;
    }

    private final void loadPlugins(KotlinModuleBuildTarget<?> representativeTarget, CommonCompilerArguments commonArguments, CompileContext context) {
        loadPlugins.1 $fun$concatenate$1 = loadPlugins.1.INSTANCE;
        for (KotlinJpsCompilerArgumentsProvider argumentProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            ModuleBuildTarget jpsModuleBuildTarget = representativeTarget.getJpsModuleBuildTarget();
            commonArguments.setPluginOptions($fun$concatenate$1.invoke(commonArguments.getPluginOptions(), argumentProvider.getExtraArguments(jpsModuleBuildTarget, context)));
            commonArguments.setPluginClasspaths($fun$concatenate$1.invoke(commonArguments.getPluginClasspaths(), argumentProvider.getClasspath(jpsModuleBuildTarget, context)));
            LOG.debug("Plugin loaded: " + argumentProvider.getClass().getSimpleName());
        }
    }

    private final JpsCompilerEnvironment createCompileEnvironment(CompileContext context, KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, LookupTracker lookupTracker, ExpectActualTracker exceptActualTracer, ModuleChunk chunk, MessageCollectorAdapter messageCollector) {
        Services.Builder builder = new Services.Builder();
        boolean bl = false;
        boolean bl2 = false;
        Services.Builder $this$with = builder;
        boolean bl3 = false;
        kotlinModuleBuilderTarget.makeServices($this$with, incrementalCaches, lookupTracker, exceptActualTracer);
        Services compilerServices = $this$with.build();
        return new JpsCompilerEnvironment(compilerServices, Companion.getClassesToLoadByParent(), messageCollector, new OutputItemsCollectorImpl(), new ProgressReporterImpl(context, chunk));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ModuleBuildTarget, List<GeneratedFile>> getGeneratedFiles(CompileContext context, ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$sortedBy$iv;
        Iterable $this$forEach$iv;
        HashMap sourceToTarget = new HashMap();
        if (chunk.getTargets().size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = KotlinCompileContextKt.getKotlin(context).getTargetsBinding().get(target);
                if (kotlinModuleBuildTarget != null && (kotlinModuleBuildTarget = kotlinModuleBuildTarget.getSourceFiles()) != null) {
                    $this$forEach$iv = (Iterable)((Object)kotlinModuleBuildTarget);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File it = (File)element$iv;
                        boolean bl = false;
                        Map map = sourceToTarget;
                        ModuleBuildTarget moduleBuildTarget = target;
                        Intrinsics.checkNotNullExpressionValue((Object)moduleBuildTarget, (String)"target");
                        map.put(it, moduleBuildTarget);
                    }
                }
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        Function1<SimpleOutputItem, ModuleBuildTarget> $fun$target$2 = new Function1<SimpleOutputItem, ModuleBuildTarget>(sourceToTarget, chunk, representativeTarget){
            final /* synthetic */ HashMap $sourceToTarget;
            final /* synthetic */ ModuleChunk $chunk;
            final /* synthetic */ ModuleBuildTarget $representativeTarget;

            public final ModuleBuildTarget invoke(@NotNull SimpleOutputItem $this$target) {
                File file2;
                File file3;
                block9: {
                    Object v6;
                    block7: {
                        block8: {
                            Intrinsics.checkNotNullParameter((Object)$this$target, (String)"$this$target");
                            file3 = (File)CollectionsKt.firstOrNull((Iterable)$this$target.getSourceFiles());
                            if (file3 == null) break block8;
                            File file4 = file3;
                            boolean bl = false;
                            boolean bl2 = false;
                            File it = file4;
                            boolean bl3 = false;
                            file3 = (ModuleBuildTarget)this.$sourceToTarget.get(it);
                            if (file3 != null) break block9;
                        }
                        Set set = this.$chunk.getTargets();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"chunk.targets");
                        Iterable $this$singleOrNull$iv = set;
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $this$singleOrNull$iv) {
                            boolean bl;
                            ModuleBuildTarget target = (ModuleBuildTarget)element$iv;
                            boolean bl4 = false;
                            ModuleBuildTarget moduleBuildTarget = target;
                            Intrinsics.checkNotNullExpressionValue((Object)moduleBuildTarget, (String)"target");
                            if (moduleBuildTarget.getOutputDir() != null) {
                                File file5;
                                boolean bl5 = false;
                                boolean bl6 = false;
                                File outputDir2 = file5;
                                boolean bl7 = false;
                                File file6 = $this$target.getOutputFile();
                                File file7 = outputDir2;
                                Intrinsics.checkNotNullExpressionValue((Object)file7, (String)"outputDir");
                                bl = FilesKt.startsWith((File)file6, (File)file7);
                            } else {
                                bl = false;
                            }
                            if (!bl) continue;
                            if (found$iv) {
                                v6 = null;
                                break block7;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v6 = !found$iv ? null : single$iv;
                    }
                    file3 = file2 = (ModuleBuildTarget)v6;
                }
                if (file3 == null) {
                    file2 = this.$representativeTarget;
                }
                return file2;
            }
            {
                this.$sourceToTarget = hashMap;
                this.$chunk = moduleChunk;
                this.$representativeTarget = moduleBuildTarget;
                super(1);
            }
        };
        List<SimpleOutputItem> list = outputItemCollector.getOutputs();
        Intrinsics.checkNotNullExpressionValue(list, (String)"outputItemCollector.outputs");
        $this$forEach$iv = list;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                SimpleOutputItem it = (SimpleOutputItem)a;
                boolean bl2 = false;
                Comparable comparable = it.getOutputFile();
                it = (SimpleOutputItem)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                File file2 = it.getOutputFile();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)file2);
            }
        });
        boolean $i$f$groupBy = false;
        void var9_11 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SimpleOutputItem p1 = (SimpleOutputItem)element$iv$iv;
            boolean bl2 = false;
            ModuleBuildTarget key$iv$iv = $fun$target$2.invoke(p1);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            p1 = (SimpleOutputItem)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl4 = false;
            GeneratedFile generatedFile = SimpleOutputItemKt.toGeneratedFile(p1);
            list2.add(generatedFile);
        }
        return destination$iv$iv;
    }

    private final void updateLookupStorage(LookupTracker lookupTracker, JpsLookupStorageManager lookupStorageManager, KotlinDirtySourceFilesHolder dirtyFilesHolder2) {
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw (Throwable)((Object)new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass())));
        }
        lookupStorageManager.withLookupStorage((Function1)new Function1<LookupStorage, Unit>(dirtyFilesHolder2, lookupTracker){
            final /* synthetic */ KotlinDirtySourceFilesHolder $dirtyFilesHolder;
            final /* synthetic */ LookupTracker $lookupTracker;

            public final void invoke(@NotNull LookupStorage lookupStorage) {
                Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
                lookupStorage.removeLookupsFrom((Sequence<? extends File>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.$dirtyFilesHolder.getAllDirtyFiles()), (Sequence)CollectionsKt.asSequence((Iterable)this.$dirtyFilesHolder.getAllRemovedFilesFiles())));
                MultiMap<LookupSymbol, String> multiMap = ((LookupTrackerImpl)this.$lookupTracker).getLookups();
                Set set = ((LookupTrackerImpl)this.$lookupTracker).getPathInterner().getValues();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"lookupTracker.pathInterner.values");
                lookupStorage.addAll(multiMap, set);
            }
            {
                this.$dirtyFilesHolder = kotlinDirtySourceFilesHolder;
                this.$lookupTracker = lookupTracker;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void markDirtyComplementaryMultifileClasses(Map<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> generatedFiles, KotlinCompileContext kotlinContext2, Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, FSOperationsHelper fsOperations) {
        ModuleBuildTarget moduleBuildTarget = generatedFiles;
        boolean bl = false;
        Iterator<Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>>> iterator2 = moduleBuildTarget.entrySet().iterator();
        while (iterator2.hasNext()) {
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object;
            Object object2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$filterTo$iv$iv;
            IncrementalJvmCache cache;
            void $this$flatMapTo$iv$iv2;
            void $this$filterTo$iv$iv2;
            Object element$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            KotlinModuleBuildTarget<?> kotlinModuleBuilderTarget;
            void target;
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry;
            Map.Entry<ModuleBuildTarget, ? extends List<? extends GeneratedFile>> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            moduleBuildTarget = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List<? extends GeneratedFile> files2 = entry2.getValue();
            if (kotlinContext2.getTargetsBinding().get(target) == null) {
                continue;
            }
            JpsIncrementalCache jpsIncrementalCache = incrementalCaches.get(kotlinModuleBuilderTarget);
            if (!(jpsIncrementalCache instanceof IncrementalJvmCache)) {
                jpsIncrementalCache = null;
            }
            if ((IncrementalJvmCache)((Object)jpsIncrementalCache) == null) {
                continue;
            }
            Iterable $this$filterIsInstance$iv = files2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof GeneratedJvmClass)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List generated = (List)destination$iv$iv;
            Iterable $this$filter$iv = generated;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            element$iv$iv2 = $this$filterTo$iv$iv2.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv3;
                boolean bl3 = false;
                if (!(it.getOutputClass().getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS)) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List multifileClasses = (List)destination$iv$iv2;
            Iterable $this$flatMap$iv2 = multifileClasses;
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = $this$flatMap$iv2;
            Iterable destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv4 : $this$flatMapTo$iv$iv2) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv4;
                boolean bl4 = false;
                Collection collection = cache.getAllPartsOfMultifileFacade(it.getOutputClass().getClassName());
                boolean bl5 = false;
                Collection collection2 = collection;
                if (collection2 == null) {
                    collection2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = collection2;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List expectedAllParts = (List)destination$iv$iv3;
            if (multifileClasses.isEmpty()) continue;
            Iterable $this$filter$iv2 = generated;
            boolean $i$f$filter2 = false;
            destination$iv$iv3 = $this$filter$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv5;
                boolean bl6 = false;
                if (!(it.getOutputClass().getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART)) continue;
                destination$iv$iv4.add(element$iv$iv5);
            }
            $this$filter$iv2 = (List)destination$iv$iv4;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)item$iv$iv;
                object2 = destination$iv$iv4;
                boolean bl7 = false;
                object = it.getOutputClass().getClassName().toString();
                object2.add(object);
            }
            List actualParts = (List)destination$iv$iv4;
            if (actualParts.containsAll(expectedAllParts)) continue;
            $this$map$iv = expectedAllParts;
            object2 = fsOperations;
            boolean $i$f$flatMap2 = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv6 : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv6;
                boolean bl8 = false;
                Iterable list$iv$iv = cache.sourcesByInternalName(it);
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            object = (List)destination$iv$iv4;
            $this$flatMap$iv = multifileClasses;
            object = (Collection)object;
            $i$f$flatMap2 = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv4 = new ArrayList();
            $i$f$flatMapTo2 = false;
            for (Object element$iv$iv7 : $this$flatMapTo$iv$iv) {
                GeneratedJvmClass it = (GeneratedJvmClass)element$iv$iv7;
                boolean bl9 = false;
                Iterable list$iv$iv = it.getSourceFiles();
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv4;
            ((FSOperationsHelper)object2).markFiles(CollectionsKt.plus((Collection)object, (Iterable)list));
        }
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#org\u2026jps.build.KotlinBuilder\")");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "()V", "JPS_KOTLIN_HOME_PROPERTY", "", "KOTLIN_BUILDER_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SKIP_CACHE_VERSION_CHECK_PROPERTY", "classesToLoadByParent", "Lorg/jetbrains/kotlin/preloading/ClassCondition;", "getClassesToLoadByParent", "()Lorg/jetbrains/kotlin/preloading/ClassCondition;", "kotlin.jps-plugin"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final ClassCondition getClassesToLoadByParent() {
            return classesToLoadByParent.1.INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

