/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.syntax;

import com.jetbrains.gsa.data.HashElem;
import com.jetbrains.gsa.data.HashTab;
import com.jetbrains.gsa.data.ListItr;
import com.jetbrains.gsa.others.GSAException;
import com.jetbrains.gsa.others.Nonterms;
import com.jetbrains.gsa.syntax.NTCat;
import com.jetbrains.gsa.syntax.NTEmpty;
import com.jetbrains.gsa.syntax.NTFew;
import com.jetbrains.gsa.syntax.NTManyKids;
import com.jetbrains.gsa.syntax.NTNonterm;
import com.jetbrains.gsa.syntax.NTOne;
import com.jetbrains.gsa.syntax.NTProduct;
import com.jetbrains.gsa.syntax.NTTerm;
import com.jetbrains.gsa.syntax.NTUnion;
import com.jetbrains.gsa.syntax.NontermNode;
import com.jetbrains.gsa.terms.ConstTerm;
import com.jetbrains.gsa.terms.StrTerm;
import com.jetbrains.gsa.terms.Terms;
import com.jetbrains.gsa.text.CType;
import com.jetbrains.gsa.text.ReadString;
import com.jetbrains.gsa.text.WriteString;

public class GrammarParser {
    private final ReadString grammar;
    public HashTab varsTable = new HashTab();
    public HashTab procsTable = new HashTab();

    public GrammarParser(ReadString grammar) {
        this.grammar = grammar;
    }

    public NontermNode parse() throws GSAException {
        return this.parse(new DelimList('|', new DelimList(',', null){

            @Override
            public NTManyKids newNonterm() {
                return new NTCat();
            }
        }){

            @Override
            public NTManyKids newNonterm() {
                return new NTUnion();
            }
        });
    }

    private NontermNode parse(DelimList list) throws GSAException {
        if (list == null) {
            return this.parseProduct();
        }
        NontermNode node2 = this.parse(list.next);
        char symbol = this.grammar.getSymbol();
        if (symbol == list.delimiter) {
            NontermNode save2 = node2;
            node2 = list.newNonterm();
            ((NTManyKids)node2).kids.add(save2);
            while (symbol == list.delimiter) {
                ((NTManyKids)node2).kids.add(this.parse(list.next));
                symbol = this.grammar.getSymbol();
            }
        }
        this.grammar.pushBack();
        return node2;
    }

    NontermNode parseProduct() throws GSAException {
        NontermNode node2 = this.getNtExpr();
        while (this.grammar.getSymbol() == '*') {
            node2 = new NTProduct(node2, this.getNtExpr());
        }
        this.grammar.pushBack();
        return node2;
    }

    NontermNode getNtExpr() throws GSAException {
        NontermNode ans;
        char symbol = this.grammar.getSymbol();
        String precFunc = null;
        if (symbol == '%') {
            precFunc = this.grammar.getID();
            symbol = this.grammar.getSymbol();
            this.procsTable.add(new Nonterms.SemanticHashElem(precFunc, false));
        }
        if (symbol == '(') {
            ans = this.parse();
            this.grammar.readSymbol(')');
        } else if (symbol == '[') {
            ans = new NTOne();
            ((NTOne)ans).son = this.parse();
            this.grammar.readSymbol(']');
        } else if (symbol == '{') {
            ans = new NTFew();
            ((NTFew)ans).son = this.parse();
            this.grammar.readSymbol('}');
        } else if (symbol == '\"') {
            ans = new NTTerm();
            ans.wasTerm = true;
            ((NTTerm)ans).term = Terms.add(new StrTerm(this.grammar.readTerm()));
        } else if (CType.isAlpha(symbol) && this.grammar.nextIsID()) {
            this.grammar.pushBack();
            ans = this.getIDNonterm(this.grammar.getID());
        } else {
            ans = new NTEmpty();
            this.grammar.pushBack();
        }
        if (ans.precFunc != null) {
            throw new GSAException(this.grammar, "Semantic action already defined");
        }
        ans.precFunc = precFunc;
        this.grammar.skipSpace();
        symbol = this.grammar.getSymbol();
        if (symbol == '%') {
            ans.conclFunc = this.grammar.getID();
            this.procsTable.add(new Nonterms.SemanticHashElem(ans.conclFunc, ans.wasTerm));
        } else {
            this.grammar.pushBack();
        }
        return ans;
    }

    private NontermNode getIDNonterm(String id) throws GSAException {
        NontermNode ans;
        if (id.equals("SEMANTIC_OR") || id.equals("RETRY_OR") || id.equals("NON_LL1_OR")) {
            this.grammar.readSymbol('(');
            ans = this.parse();
            if (ans instanceof NTUnion) {
                if (((NTUnion)ans).state != 0) {
                    throw new GSAException(this.grammar, "Union can have only one option");
                }
                if (id.equals("SEMANTIC_OR")) {
                    this.checkSemantics((NTUnion)ans);
                    ((NTUnion)ans).state = 1;
                } else if (id.equals("RETRY_OR")) {
                    ((NTUnion)ans).state = 2;
                }
            } else {
                throw new GSAException(this.grammar, "Union expression expected");
            }
            ((NTUnion)ans).checkLL1 = false;
            this.grammar.readSymbol(')');
        } else if (CType.isUpperID(id)) {
            ans = new NTTerm();
            ans.wasTerm = true;
            ((NTTerm)ans).term = Terms.add(new ConstTerm(id));
        } else {
            ans = new NTNonterm();
            ((NTNonterm)ans).nonterm = Nonterms.add(new Nonterms.Nonterm(id));
            ((NTNonterm)ans).varName = this.grammar.getID();
            this.addVar(id, ((NTNonterm)ans).varName);
        }
        return ans;
    }

    private void checkSemantics(NTUnion node2) throws GSAException {
        ListItr itr = new ListItr(node2.kids);
        while (!itr.isDone()) {
            String func = ((NontermNode)itr.get()).precFunc;
            if (func == null) {
                throw new GSAException(this.grammar, "Not all variants in this union have choose-semantics");
            }
            ((Nonterms.SemanticHashElem)this.procsTable.search((String)func)).isSemanticOr = true;
            itr.next();
        }
    }

    void addVar(String clName, String varName) {
        WriteString ans = new WriteString();
        ans.curTab = 1;
        ans.appendf("public " + clName + " " + varName + ";");
        this.varsTable.add(new HashElem(ans.toString()));
    }

    private static abstract class DelimList {
        public char delimiter;
        public DelimList next;

        DelimList(char delimiter, DelimList next) {
            this.delimiter = delimiter;
            this.next = next;
        }

        public abstract NTManyKids newNonterm();
    }
}

