/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cmake.settings.CMakeTabbedLanguageCodeStylePanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    @Nullable
    public Language getLanguage() {
        return CMakeLanguage.INSTANCE;
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new CMakeCodeStyleSettings(settings);
    }

    @NotNull
    public Configurable createSettingsPage(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings originalSettings) {
        return new CodeStyleAbstractConfigurable(settings, originalSettings, this.getConfigurableDisplayName()){

            @Nullable
            public String getHelpTopic() {
                return "Code_Style_CMake";
            }

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new CMakeTabbedLanguageCodeStylePanel(this.getCurrentSettings(), settings);
            }
        };
    }

    @NotNull
    public DisplayPriority getPriority() {
        return DisplayPriority.LANGUAGE_SETTINGS;
    }

    @NotNull
    public String getConfigurableDisplayName() {
        return CMakeLanguage.INSTANCE.getDisplayName();
    }
}

